/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import java.util.List;
import javax.lang.model.element.Modifier;

public class Gen_Multi_RegistryFactory
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getRegistryClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(ClassName.get("lombok", "Value", new String[0]));
        classBuilder.addField(FieldSpec.builder(ClassName.bestGuess(registry.getTableClassName()), "tables", new Modifier[0]).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).build());
        for (TableMetamodel table : tables) {
            classBuilder.addMethod(this.generateFactoryMethod(table));
        }
        return JavaFile.builder(registry.getPackageName() + ".spi", classBuilder.build()).indent("  ").build();
    }

    private MethodSpec generateFactoryMethod(TableMetamodel table) {
        String methodName = NamingUtils.pluralize(table.getTableName());
        String implName = table.getImplClassName();
        return MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).returns(ClassName.bestGuess(implName)).addStatement("return new $L(tables, dataSource)", implName).build();
    }
}

