/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class Gen_Multi_QueryInterface
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getName() + "DbQuery";
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder(className).addModifiers(Modifier.PUBLIC);
        interfaceBuilder.addMethod(MethodSpec.methodBuilder("findAll").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Uni", new String[0]), ClassName.bestGuess(registry.getWorldName()))).build());
        for (TableMetamodel table : tables) {
            String queryMethodName = "query" + NamingUtils.toPascalCase(table.getTableName());
            String nestedInterfaceName = NamingUtils.toPascalCase(table.getTableName()) + "Query";
            interfaceBuilder.addMethod(MethodSpec.methodBuilder(queryMethodName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ClassName.bestGuess(nestedInterfaceName)).build());
            interfaceBuilder.addType(this.generateTableQueryInterface(table, nestedInterfaceName));
        }
        interfaceBuilder.addType(this.generateWorldInterface(registry, tables));
        return JavaFile.builder(registry.getPackageName(), interfaceBuilder.build()).indent("  ").build();
    }

    private TypeSpec generateTableQueryInterface(TableMetamodel table, String interfaceName) {
        TypeSpec.Builder nestedInterface = TypeSpec.interfaceBuilder(interfaceName).addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
            if (method.getType() != TableMetamodel.SqlMethodType.SELECT && method.getType() != TableMetamodel.SqlMethodType.SELECT_ALL) continue;
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(method.getMethodName()).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
            for (TableMetamodel.MethodParameter param : method.getParameters()) {
                methodBuilder.addParameter(param.getType(), param.getName(), new Modifier[0]);
            }
            TypeName entityType = Optional.ofNullable(method.getReturnType()).orElse(ClassName.get(Object.class));
            if (method.getType() == TableMetamodel.SqlMethodType.SELECT && method.isOptional()) {
                methodBuilder.returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Uni", new String[0]), ParameterizedTypeName.get(ClassName.get("java.util", "Optional", new String[0]), entityType)));
            } else if (method.getType() == TableMetamodel.SqlMethodType.SELECT && !method.isOptional()) {
                methodBuilder.returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Uni", new String[0]), entityType));
            } else if (method.getType() == TableMetamodel.SqlMethodType.SELECT_ALL && method.isMultiWrapper()) {
                methodBuilder.returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Multi", new String[0]), entityType));
            } else {
                methodBuilder.returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Uni", new String[0]), ParameterizedTypeName.get(ClassName.get("java.util", "List", new String[0]), entityType)));
            }
            nestedInterface.addMethod(methodBuilder.build());
        }
        return nestedInterface.build();
    }

    private TypeSpec generateWorldInterface(RegistryMetamodel registry, List<TableMetamodel> tables) {
        TypeSpec.Builder worldInterface = TypeSpec.interfaceBuilder(registry.getWorldName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addAnnotation(AnnotationSpec.builder(ClassName.get("org.immutables.value", "Value", "Immutable")).build());
        for (TableMetamodel table : tables) {
            ClassName entityType = this.findEntityTypeForTable(table);
            if (entityType == null) continue;
            String getterName = "get" + NamingUtils.toPascalCase(table.getTableName());
            ParameterizedTypeName returnType = ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(String.class), entityType);
            worldInterface.addMethod(MethodSpec.methodBuilder(getterName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(returnType).build());
        }
        return worldInterface.build();
    }

    private ClassName findEntityTypeForTable(TableMetamodel table) {
        for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
            if (method.getType() != TableMetamodel.SqlMethodType.SELECT_ALL || !method.getParameters().isEmpty() || method.getReturnType() == null) continue;
            return (ClassName)method.getReturnType();
        }
        return null;
    }
}

