/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.api.LogConstants;
import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.RowSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class Gen_Multi_QueryImplementation
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getName() + "DbQueryImpl";
        String interfaceName = registry.getName() + "DbQuery";
        String packageName = registry.getPackageName() + ".spi";
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC).addSuperinterface(ClassName.get(registry.getPackageName(), interfaceName, new String[0])).addAnnotation(AnnotationSpec.builder(ClassName.get("lombok.extern.slf4j", "Slf4j", new String[0])).addMember("topic", "$T.SHOW_SQL", ClassName.get(LogConstants.class)).build()).addAnnotation(ClassName.get("lombok", "RequiredArgsConstructor", new String[0]));
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSource.class), "dataSource", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addField(FieldSpec.builder(ClassName.bestGuess(registry.getRegistryClassName()), "registry", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSourceErrorHandler.class), "errorHandler", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addMethod(this.generateConstructor(registry));
        classBuilder.addMethod(this.generateFindAllMethod(registry, tables));
        for (TableMetamodel table : tables) {
            classBuilder.addMethod(this.generateQueryTableMethod(registry, table));
        }
        return JavaFile.builder(packageName, classBuilder.build()).indent("  ").build();
    }

    private MethodSpec generateConstructor(RegistryMetamodel registry) {
        return MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).addStatement("this.dataSource = dataSource", new Object[0]).addStatement("final var names = $T.defaults().toRepo(dataSource.getTenant())", ClassName.bestGuess(registry.getTableClassName())).addStatement("this.registry = new $T(names, dataSource)", ClassName.bestGuess(registry.getRegistryClassName())).addStatement("this.errorHandler = dataSource.getErrorHandler()", new Object[0]).build();
    }

    private MethodSpec generateFindAllMethod(RegistryMetamodel registry, List<TableMetamodel> tables) {
        int i;
        TableMetamodel table2;
        MethodSpec.Builder method = MethodSpec.methodBuilder("findAll").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.bestGuess(registry.getWorldName())));
        ArrayList<TableMetamodel> tablesWithFindAll = new ArrayList<TableMetamodel>();
        for (TableMetamodel table2 : tables) {
            if (this.findEntityTypeForTable(table2) == null) continue;
            tablesWithFindAll.add(table2);
        }
        if (tablesWithFindAll.isEmpty()) {
            method.addStatement("return $T.createFrom().item($T.builder().build())", Uni.class, ClassName.get(registry.getPackageName(), "Immutable" + registry.getWorldName(), new String[0]));
            return method.build();
        }
        method.addCode("return $T.combine().all()\n", Uni.class);
        method.addCode("$>.unis(\n", new Object[0]);
        method.addCode("$>", new Object[0]);
        for (i = 0; i < tablesWithFindAll.size(); ++i) {
            table2 = (TableMetamodel)tablesWithFindAll.get(i);
            String methodName = "query" + NamingUtils.toPascalCase(table2.getTableName());
            TableMetamodel.SqlMethod findAllMethod = this.findNoArgFindAllMethod(table2);
            if (i > 0) {
                method.addCode(",\n", new Object[0]);
            }
            method.addCode("$L().$L()", methodName, findAllMethod.getMethodName());
        }
        method.addCode("\n$<", new Object[0]);
        method.addCode(")\n$<", new Object[0]);
        method.addCode(".with(sets -> {\n", new Object[0]);
        method.addCode("$>final var builder = $T.builder();\n", ClassName.get(registry.getPackageName(), "Immutable" + registry.getWorldName(), new String[0]));
        for (i = 0; i < tablesWithFindAll.size(); ++i) {
            table2 = (TableMetamodel)tablesWithFindAll.get(i);
            ClassName entityType = this.findEntityTypeForTable(table2);
            method.addCode("final $T<$T> item_$L = ($T<$T>) sets.get($L);\n", List.class, entityType, i, List.class, entityType, i);
        }
        method.addCode("\n", new Object[0]);
        for (i = 0; i < tablesWithFindAll.size(); ++i) {
            table2 = (TableMetamodel)tablesWithFindAll.get(i);
            String builderMethodName = NamingUtils.lowerCamelCase(NamingUtils.toPascalCase(table2.getTableName()));
            method.addCode("builder.$L(item_$L\n", builderMethodName, i);
            method.addCode("$>.stream()\n", new Object[0]);
            method.addCode(".collect($T.toMap(\n", ClassName.get("java.util.stream", "Collectors", new String[0]));
            method.addCode("$>e -> e.getId(),\n", new Object[0]);
            method.addCode("e -> e\n$<", new Object[0]);
            method.addCode(")));$<\n", new Object[0]);
            if (i >= tablesWithFindAll.size() - 1) continue;
            method.addCode("\n", new Object[0]);
        }
        method.addCode("\nreturn builder.build();\n$<", new Object[0]);
        method.addCode("});\n", new Object[0]);
        return method.build();
    }

    private ClassName findEntityTypeForTable(TableMetamodel table) {
        for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
            if (method.getType() != TableMetamodel.SqlMethodType.SELECT_ALL || !method.getParameters().isEmpty() || method.getReturnType() == null) continue;
            return (ClassName)method.getReturnType();
        }
        return null;
    }

    private TableMetamodel.SqlMethod findNoArgFindAllMethod(TableMetamodel table) {
        for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
            if (method.getType() != TableMetamodel.SqlMethodType.SELECT_ALL || !method.getParameters().isEmpty()) continue;
            return method;
        }
        return null;
    }

    private MethodSpec generateQueryTableMethod(RegistryMetamodel registry, TableMetamodel table) {
        String methodName = "query" + NamingUtils.toPascalCase(table.getTableName());
        String nestedInterfaceName = NamingUtils.toPascalCase(table.getTableName()) + "Query";
        String registryGetter = NamingUtils.pluralize(table.getTableName());
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.bestGuess(nestedInterfaceName));
        method.addCode("return new $L() {\n", nestedInterfaceName);
        method.addCode("$>", new Object[0]);
        for (TableMetamodel.SqlMethod sqlMethod : table.getSqlMethods()) {
            if (sqlMethod.getType() != TableMetamodel.SqlMethodType.SELECT && sqlMethod.getType() != TableMetamodel.SqlMethodType.SELECT_ALL) continue;
            method.addCode("\n", new Object[0]);
            method.addCode(this.generateQueryMethodImpl(registry, table, sqlMethod, registryGetter));
        }
        method.addCode("$<", new Object[0]);
        method.addStatement("}", new Object[0]);
        return method.build();
    }

    private CodeBlock generateQueryMethodImpl(RegistryMetamodel registry, TableMetamodel table, TableMetamodel.SqlMethod sqlMethod, String registryGetter) {
        int i;
        CodeBlock.Builder code = CodeBlock.builder();
        String className = registry.getName() + "DbQueryImpl";
        TypeName entityType = sqlMethod.getReturnType();
        code.add("@$T\n", Override.class);
        code.add("public ", new Object[0]);
        if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT && sqlMethod.isOptional()) {
            code.add("$T<$T<$T>> ", Uni.class, Optional.class, entityType);
        } else if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT && !sqlMethod.isOptional()) {
            code.add("$T<$T> ", Uni.class, entityType);
        } else if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT_ALL && sqlMethod.isMultiWrapper()) {
            code.add("$T<$T> ", Multi.class, entityType);
        } else {
            code.add("$T<$T<$T>> ", Uni.class, List.class, entityType);
        }
        code.add("$L(", sqlMethod.getMethodName());
        for (i = 0; i < sqlMethod.getParameters().size(); ++i) {
            TableMetamodel.MethodParameter param = sqlMethod.getParameters().get(i);
            if (i > 0) {
                code.add(", ", new Object[0]);
            }
            code.add("$T $L", param.getType(), param.getName());
        }
        code.add(") {\n", new Object[0]);
        code.indent();
        code.add("final var sql = registry.$L().$L(", registryGetter, sqlMethod.getMethodName());
        for (i = 0; i < sqlMethod.getParameters().size(); ++i) {
            if (i > 0) {
                code.add(", ", new Object[0]);
            }
            code.add("$L", sqlMethod.getParameters().get(i).getName());
        }
        code.add(");\n", new Object[0]);
        code.add("\n", new Object[0]);
        code.add("if(log.isDebugEnabled()) {\n", new Object[0]);
        code.indent();
        if (sqlMethod.getParameters().isEmpty()) {
            code.add("log.debug(\"$L.$L.$L query, with props: {} \\r\\n{}\",\n", className, "query" + NamingUtils.toPascalCase(table.getTableName()), sqlMethod.getMethodName());
            code.indent();
            code.add("\"\",\n", new Object[0]);
        } else {
            code.add("log.debug(\"$L.$L.$L query, with props: {} \\r\\n{}\",\n", className, "query" + NamingUtils.toPascalCase(table.getTableName()), sqlMethod.getMethodName());
            code.indent();
            code.add("sql.getProps().deepToString(),\n", new Object[0]);
        }
        code.add("sql.getValue());\n", new Object[0]);
        code.unindent();
        code.unindent();
        code.add("}\n\n", new Object[0]);
        code.add("@$T(\"unchecked\")\n", SuppressWarnings.class);
        code.add("final $T<$T> mapper = ($T<$T>) sql.getRowMapper();\n", ClassName.get(TenantSql.RowMapper.class), entityType, ClassName.get(TenantSql.RowMapper.class), entityType);
        code.add("\n", new Object[0]);
        code.add("return dataSource.getClient().preparedQuery(sql.getValue())\n", new Object[0]);
        code.indent();
        code.add(".mapping(mapper::apply)\n", new Object[0]);
        if (sqlMethod.getParameters().isEmpty()) {
            code.add(".execute()\n", new Object[0]);
        } else {
            code.add(".execute(sql.getProps())\n", new Object[0]);
        }
        code.add(".onItem()\n", new Object[0]);
        if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT && sqlMethod.isOptional()) {
            code.add(".transform(($T<$T> rowset) -> {\n", RowSet.class, entityType);
            code.indent();
            code.add("final var iterator = rowset.iterator();\n", new Object[0]);
            code.add("if(iterator.hasNext()) {\n", new Object[0]);
            code.indent();
            code.add("return $T.of(iterator.next());\n", Optional.class);
            code.unindent();
            code.add("}\n", new Object[0]);
            code.add("return $T.<$T>empty();\n", Optional.class, entityType);
            code.unindent();
            code.add("})\n", new Object[0]);
        } else if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT && !sqlMethod.isOptional()) {
            code.add(".transform(($T<$T> rowset) -> {\n", RowSet.class, entityType);
            code.indent();
            code.add("final var iterator = rowset.iterator();\n", new Object[0]);
            code.add("if(iterator.hasNext()) {\n", new Object[0]);
            code.indent();
            code.add("return iterator.next();\n", new Object[0]);
            code.unindent();
            code.add("}\n", new Object[0]);
            code.add("throw new $T(\"$L not found!\");\n", ClassName.get(registry.getPackageName() + ".spi", registry.getName() + "FindException", new String[0]), entityType.toString());
            code.unindent();
            code.add("})\n", new Object[0]);
        } else if (sqlMethod.getType() == TableMetamodel.SqlMethodType.SELECT_ALL && sqlMethod.isMultiWrapper()) {
            code.add(".transformToMulti(($T<$T> rowset) -> $T.createFrom().iterable(rowset))\n", RowSet.class, entityType, Multi.class);
        } else {
            code.add(".transformToUni(($T<$T> rowset) -> $T.createFrom().iterable(rowset).collect().asList())\n", RowSet.class, entityType, Multi.class);
        }
        if (sqlMethod.getParameters().isEmpty()) {
            code.add(".onFailure().invoke(e -> errorHandler.deadEnd(new $T(\"Can't find '$L's!\", sql, e)));\n", ThenaSqlDataSourceErrorHandler.SqlFailed.class, table.getTableName().toUpperCase());
        } else {
            code.add(".onFailure().invoke(e -> errorHandler.deadEnd(new $T(\"Can't find '$L's!\", sql, e)));\n", ThenaSqlDataSourceErrorHandler.SqlTupleFailed.class, table.getTableName().toUpperCase());
        }
        code.unindent();
        code.unindent();
        code.add("}\n", new Object[0]);
        return code.build();
    }
}

