/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import io.resys.thena.registry.TenantRegistrySqlImpl;
import io.resys.thena.spi.InternalTenantQueryImpl;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public class Gen_Multi_InternalTenantQuery
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getInternalTenantQueryClassName();
        String packageName = registry.getPackageName() + ".spi";
        List<TableMetamodel> sortedTables = tables.stream().sorted(Comparator.comparingInt(TableMetamodel::getOrder)).toList();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC).superclass(ClassName.get(InternalTenantQueryImpl.class)).addSuperinterface(ClassName.get(TenantDataSource.InternalTenantQuery.class)).addAnnotation(AnnotationSpec.builder(ClassName.get("lombok.extern.slf4j", "Slf4j", new String[0])).addMember("topic", "$S", "io.resys.thena.show_sql").build());
        classBuilder.addMethod(this.generateConstructor());
        classBuilder.addMethod(this.generateInsert(registry, sortedTables));
        classBuilder.addMethod(this.generateDelete(registry, sortedTables));
        return JavaFile.builder(packageName, classBuilder.build()).indent("  ").build();
    }

    private MethodSpec generateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).addStatement("super(dataSource)", new Object[0]).build();
    }

    private MethodSpec generateInsert(RegistryMetamodel registry, List<TableMetamodel> sortedTables) {
        return MethodSpec.methodBuilder("insert").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(Tenant.class), "newRepo", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.get(Tenant.class))).addCode(this.generateInsertBody(registry, sortedTables)).build();
    }

    private CodeBlock generateInsertBody(RegistryMetamodel registry, List<TableMetamodel> sortedTables) {
        String getter;
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("final var names = $T.defaults().toRepo(newRepo);\n", ClassName.bestGuess(registry.getTableClassName()));
        code.add("final var next = dataSource.withTenant(newRepo);\n", new Object[0]);
        code.add("final var registry = new $T(names, next);\n", ClassName.get(registry.getPackageName() + ".spi", registry.getRegistryClassName(), new String[0]));
        code.add("final var sqlQuery = new $T(next.getTenantContext());\n", ClassName.get(TenantRegistrySqlImpl.class));
        code.add("final var pool = next.getPool();\n\n", new Object[0]);
        code.add("return pool.withTransaction(tx -> {\n", new Object[0]);
        code.indent();
        code.add("final var tenantInsert = sqlQuery.insertOne(newRepo);\n", new Object[0]);
        code.add("final var tablesCreate = new $T();\n", StringBuilder.class);
        code.add("$T.isTrue(newRepo.getType() == $T.$L, () -> \"Tenant type must be $L\");\n\n", ClassName.get(RepoAssert.class), ClassName.get(Tenant.StructureType.class), registry.getTenantType(), registry.getTenantType());
        code.add("tablesCreate\n", new Object[0]);
        code.indent();
        for (TableMetamodel table : sortedTables) {
            getter = NamingUtils.pluralize(table.getTableName());
            code.add(".append(registry.$L().createTable().getValue())\n", getter);
        }
        code.add("\n", new Object[0]);
        for (TableMetamodel table : sortedTables) {
            if (StringUtils.isEmpty(table.getConstraintsSql().trim())) continue;
            getter = NamingUtils.pluralize(table.getTableName());
            code.add(".append(registry.$L().createConstraints().getValue())\n", getter);
        }
        code.add(".toString();\n", new Object[0]);
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("if(log.isDebugEnabled()) {\n", new Object[0]);
        code.indent();
        code.add("log.debug(new $T(\"Creating schema: \")\n", StringBuilder.class);
        code.indent();
        code.add(".append($T.lineSeparator())\n", System.class);
        code.add(".append(tablesCreate.toString())\n", new Object[0]);
        code.add(".toString());\n", new Object[0]);
        code.unindent();
        code.unindent();
        code.add("}\n\n", new Object[0]);
        code.add("final $T<Void> create = getClient().query(sqlQuery.createTable().getValue()).execute()\n", ClassName.get(Uni.class));
        code.indent();
        code.add(".onItem().transformToUni(data -> $T.createFrom().voidItem())\n", ClassName.get(Uni.class));
        code.add(".onFailure().invoke(e -> next.getErrorHandler().deadEnd(new $T(\"Can't create table 'TENANT'!\", sqlQuery.createTable(), e)));\n", ClassName.get(ThenaSqlDataSourceErrorHandler.SqlFailed.class));
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("final $T<Void> insert = tx.preparedQuery(tenantInsert.getValue()).execute(tenantInsert.getProps())\n", ClassName.get(Uni.class));
        code.indent();
        code.add(".onItem().transformToUni(rowSet -> $T.createFrom().voidItem())\n", ClassName.get(Uni.class));
        code.add(".onFailure().invoke(e -> next.getErrorHandler().deadEnd(new $T(\"Can't insert into 'TENANT'!\", tenantInsert, e)));\n", ClassName.get(ThenaSqlDataSourceErrorHandler.SqlTupleFailed.class));
        code.unindent();
        code.add("final $T<Void> nested = tx.query(tablesCreate.toString()).execute()\n", ClassName.get(Uni.class));
        code.indent();
        code.add(".onItem().transformToUni(rowSet -> $T.createFrom().voidItem())\n", ClassName.get(Uni.class));
        code.add(".onFailure().invoke(e -> next.getErrorHandler().deadEnd(new $T(\"Can't create tables!\", tablesCreate.toString(), e)));\n", ClassName.get(ThenaSqlDataSourceErrorHandler.SqlSchemaFailed.class));
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("return create\n", new Object[0]);
        code.indent();
        code.add(".onItem().transformToUni((junk) -> insert)\n", new Object[0]);
        code.add(".onItem().transformToUni((junk) -> nested)\n", new Object[0]);
        code.add(".onItem().transform(junk -> newRepo)\n", new Object[0]);
        code.add(".onItem().invoke(newTenant -> this.dataSource.getTenantCache().setTenant(newTenant));\n", new Object[0]);
        code.unindent();
        code.unindent();
        code.add("});\n", new Object[0]);
        return code.build();
    }

    private MethodSpec generateDelete(RegistryMetamodel registry, List<TableMetamodel> sortedTables) {
        return MethodSpec.methodBuilder("delete").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(Tenant.class), "newRepo", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.get(Tenant.class))).addCode(this.generateDeleteBody(registry, sortedTables)).build();
    }

    private CodeBlock generateDeleteBody(RegistryMetamodel registry, List<TableMetamodel> sortedTables) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("final var names = $T.defaults().toRepo(newRepo);\n", ClassName.bestGuess(registry.getTableClassName()));
        code.add("final var next = dataSource.withTenant(newRepo);\n", new Object[0]);
        code.add("final var registry = new $T(names, next);\n", ClassName.get(registry.getPackageName() + ".spi", registry.getRegistryClassName(), new String[0]));
        code.add("final var sqlQuery = new $T(next.getTenantContext());\n", ClassName.get(TenantRegistrySqlImpl.class));
        code.add("final var pool = next.getPool();\n\n", new Object[0]);
        code.add("return pool.withTransaction(tx -> {\n", new Object[0]);
        code.indent();
        code.add("final var tenantDelete = sqlQuery.deleteOne(newRepo);\n", new Object[0]);
        code.add("final var tablesDrop = new $T();\n", StringBuilder.class);
        code.add("$T.isTrue(newRepo.getType() == $T.$L, () -> \"Tenant type must be $L\");\n\n", ClassName.get(RepoAssert.class), ClassName.get(Tenant.StructureType.class), registry.getTenantType(), registry.getTenantType());
        code.add("tablesDrop\n", new Object[0]);
        code.indent();
        SequencedCollection reversedTables = sortedTables.reversed();
        for (TableMetamodel table : reversedTables) {
            String getter = NamingUtils.pluralize(table.getTableName());
            code.add(".append(registry.$L().dropTable().getValue())\n", getter);
        }
        code.add(".toString();\n", new Object[0]);
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("if(log.isDebugEnabled()) {\n", new Object[0]);
        code.indent();
        code.add("log.debug(\"Delete tenant by name query, with props: {} \\r\\n{}\",\n", new Object[0]);
        code.indent();
        code.add("tenantDelete.getProps().deepToString(),\n", new Object[0]);
        code.add("tenantDelete.getValue());\n", new Object[0]);
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("log.debug(new $T(\"Drop schema: \")\n", StringBuilder.class);
        code.indent();
        code.add(".append($T.lineSeparator())\n", System.class);
        code.add(".append(tablesDrop.toString())\n", new Object[0]);
        code.add(".toString());\n", new Object[0]);
        code.unindent();
        code.unindent();
        code.add("}\n\n", new Object[0]);
        code.add("final $T<Void> insert = tx.preparedQuery(tenantDelete.getValue()).execute(tenantDelete.getProps())\n", ClassName.get(Uni.class));
        code.indent();
        code.add(".onItem().transformToUni(rowSet -> $T.createFrom().voidItem())\n", ClassName.get(Uni.class));
        code.add(".onFailure().invoke(e -> next.getErrorHandler().deadEnd(new $T(\"Can't delete from 'TENANT'!\", tenantDelete, e)));\n", ClassName.get(ThenaSqlDataSourceErrorHandler.SqlTupleFailed.class));
        code.unindent();
        code.add("final $T<Void> nested = tx.query(tablesDrop.toString()).execute()\n", ClassName.get(Uni.class));
        code.indent();
        code.add(".onItem().transformToUni(rowSet -> $T.createFrom().voidItem())\n", ClassName.get(Uni.class));
        code.add(".onFailure().invoke(e -> next.getErrorHandler().deadEnd(new $T(\"Can't drop tables!\", tablesDrop.toString(), e)));\n", ClassName.get(ThenaSqlDataSourceErrorHandler.SqlSchemaFailed.class));
        code.unindent();
        code.add("\n", new Object[0]);
        code.add("return insert\n", new Object[0]);
        code.indent();
        code.add(".onItem().transformToUni(junk -> nested)\n", new Object[0]);
        code.add(".onItem().transform(junk -> newRepo)\n", new Object[0]);
        code.add(".onItem().invoke(() -> this.dataSource.getTenantCache().invalidateAll());\n", new Object[0]);
        code.unindent();
        code.unindent();
        code.add("});\n", new Object[0]);
        return code.build();
    }
}

