/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.api.entities.BatchLog;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class Gen_Multi_BuilderInterface
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getName() + "DbBuilder";
        String persistenceUnitName = "PersistenceUnit";
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder(className).addModifiers(Modifier.PUBLIC);
        interfaceBuilder.addMethod(MethodSpec.methodBuilder("from").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameter(ClassName.bestGuess("PersistenceUnit"), "unit", new Modifier[0]).returns(ClassName.bestGuess(className)).build());
        interfaceBuilder.addMethod(MethodSpec.methodBuilder("persist").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get("io.smallrye.mutiny", "Uni", new String[0]), ClassName.bestGuess("PersistenceUnit"))).build());
        Map<String, TypeName> operations = this.extractOperations(tables);
        interfaceBuilder.addType(this.generatePersistenceUnitInterface("PersistenceUnit", operations));
        return JavaFile.builder(registry.getPackageName(), interfaceBuilder.build()).indent("  ").build();
    }

    private Map<String, TypeName> extractOperations(List<TableMetamodel> tables) {
        HashMap<String, TypeName> operations = new HashMap<String, TypeName>();
        for (TableMetamodel table : tables) {
            for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
                TypeName entityType;
                String fieldName;
                if (method.getType() != TableMetamodel.SqlMethodType.INSERT_ALL && method.getType() != TableMetamodel.SqlMethodType.UPDATE_ALL && method.getType() != TableMetamodel.SqlMethodType.DELETE_ALL || (fieldName = this.buildOperationFieldName(table, method.getType())) == null || operations.containsKey(fieldName) || (entityType = this.extractEntityType(method)) == null) continue;
                operations.put(fieldName, entityType);
            }
        }
        return operations;
    }

    private String buildOperationFieldName(TableMetamodel table, TableMetamodel.SqlMethodType type) {
        String baseName = NamingUtils.toPascalCase(table.getTableName());
        return switch (type) {
            case TableMetamodel.SqlMethodType.INSERT_ALL -> baseName + "Inserts";
            case TableMetamodel.SqlMethodType.UPDATE_ALL -> baseName + "Updates";
            case TableMetamodel.SqlMethodType.DELETE_ALL -> baseName + "Deletes";
            default -> null;
        };
    }

    private TypeName extractEntityType(TableMetamodel.SqlMethod method) {
        if (method.getParameters().isEmpty()) {
            return null;
        }
        TableMetamodel.MethodParameter firstParam = method.getParameters().get(0);
        TypeName paramType = firstParam.getType();
        if (paramType instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)paramType;
            if (!parameterized.typeArguments.isEmpty()) {
                return parameterized.typeArguments.get(0);
            }
        }
        return paramType;
    }

    private TypeSpec generatePersistenceUnitInterface(String interfaceName, Map<String, TypeName> operations) {
        TypeSpec.Builder persistenceUnit = TypeSpec.interfaceBuilder(interfaceName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addAnnotation(AnnotationSpec.builder(ClassName.get("org.immutables.value", "Value", "Immutable")).build());
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getCommitMessages").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get(List.class), ClassName.get(String.class))).build());
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getCommitAuthors").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get(List.class), ClassName.get(String.class))).build());
        for (Map.Entry<String, TypeName> entry : operations.entrySet()) {
            String fieldName = entry.getKey();
            TypeName entityType = entry.getValue();
            persistenceUnit.addMethod(MethodSpec.methodBuilder("get" + fieldName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get(List.class), entityType)).build());
        }
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getTenantId").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns((Type)((Object)String.class)).build());
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getStatus").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ClassName.get(BatchStatus.class)).build());
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getLog").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns((Type)((Object)String.class)).build());
        persistenceUnit.addMethod(MethodSpec.methodBuilder("getCommitLogs").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ParameterizedTypeName.get(ClassName.get(List.class), ClassName.get(BatchLog.class))).build());
        persistenceUnit.addMethod(this.generateMergeListMethod(interfaceName));
        persistenceUnit.addMethod(this.generateMergeSingleMethod(interfaceName));
        persistenceUnit.addMethod(this.generateMergeBuilderMethod(interfaceName, operations));
        return persistenceUnit.build();
    }

    private MethodSpec generateMergeListMethod(String interfaceName) {
        return MethodSpec.methodBuilder("merge").addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).addParameter(ParameterizedTypeName.get(ClassName.get(List.class), ClassName.bestGuess(interfaceName)), "src", new Modifier[0]).returns(ClassName.bestGuess(interfaceName)).addStatement("final var builder = Immutable$L.builder().from(this)", interfaceName).addStatement("src.forEach(entry -> entry.merge(builder))", new Object[0]).addStatement("return builder.build()", new Object[0]).build();
    }

    private MethodSpec generateMergeSingleMethod(String interfaceName) {
        return MethodSpec.methodBuilder("merge").addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).addParameter(ClassName.bestGuess(interfaceName), "src", new Modifier[0]).returns(ClassName.bestGuess(interfaceName)).addStatement("return merge(Immutable$L.builder().from(src)).build()", interfaceName).build();
    }

    private MethodSpec generateMergeBuilderMethod(String interfaceName, Map<String, TypeName> operations) {
        ClassName builderType = ClassName.bestGuess("Immutable" + interfaceName + ".Builder");
        MethodSpec.Builder method = MethodSpec.methodBuilder("merge").addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).addParameter(builderType, "target", new Modifier[0]).returns(builderType);
        CodeBlock.Builder code = CodeBlock.builder().add("return target\n", new Object[0]).indent();
        for (String fieldName : operations.keySet()) {
            code.add(".addAll$L(this.get$L())\n", fieldName, fieldName);
        }
        code.add(".addAllCommitLogs(this.getCommitLogs())", new Object[0]);
        code.add(".addAllCommitMessages(this.getCommitMessages())\n", new Object[0]);
        code.add(".addAllCommitAuthors(this.getCommitAuthors());", new Object[0]);
        code.unindent();
        method.addCode(code.build());
        return method.build();
    }
}

