/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.api.entities.ImmutableBatchLog;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import io.smallrye.mutiny.Uni;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class Gen_Multi_BuilderImplementation
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getName() + "DbBuilderImpl";
        String builderInterfaceName = registry.getName() + "DbBuilder";
        String persistenceUnitName = builderInterfaceName + ".PersistenceUnit";
        String registryClassName = registry.getRegistryClassName();
        Map<String, OperationInfo> operations = this.extractOperations(tables);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addSuperinterface(ClassName.get(registry.getPackageName(), builderInterfaceName, new String[0]));
        classBuilder.addField(this.generateLoggerField(registry));
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlClient.class), "tx", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSource.class), "dataSource", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addField(FieldSpec.builder(ClassName.bestGuess(registryClassName), "registry", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addField(FieldSpec.builder(StringBuilder.class, "txLog", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(registry.getPackageName(), "ImmutablePersistenceUnit", "Builder"), "init", Modifier.PRIVATE, Modifier.FINAL).initializer("ImmutablePersistenceUnit.builder()", new Object[0]).build());
        classBuilder.addMethod(this.generateConstructor(registry, registryClassName));
        classBuilder.addMethod(this.generateFromMethod(registry, builderInterfaceName));
        classBuilder.addMethod(this.generatePersistMethod(registry, builderInterfaceName, persistenceUnitName, operations, tables));
        for (Map.Entry<String, OperationInfo> entry : operations.entrySet()) {
            String operation = entry.getKey();
            TableMetamodel table = entry.getValue().table;
            TypeName entityType = entry.getValue().entityType;
            classBuilder.addMethod(this.generateVisitMethod(registry, persistenceUnitName, operation, table, entityType));
        }
        classBuilder.addMethod(this.generateVisitExecutionMethod(registry, persistenceUnitName));
        classBuilder.addMethod(this.generateVisitTxLogMethod());
        classBuilder.addMethod(this.generateVisitSuccessMethod(registry, persistenceUnitName));
        classBuilder.addMethod(this.generateVisitErrorMethod(registry, persistenceUnitName));
        classBuilder.addType(this.generateExceptionClass(registry, persistenceUnitName));
        return JavaFile.builder(registry.getPackageName() + ".spi", classBuilder.build()).indent("  ").build();
    }

    private FieldSpec generateLoggerField(RegistryMetamodel registry) {
        String loggerTopic = registry.getPackageName() + "." + registry.getName().toLowerCase() + ".show_sql";
        return FieldSpec.builder(ClassName.get("org.slf4j", "Logger", new String[0]), "log", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("$T.getLogger($S)", ClassName.get("org.slf4j", "LoggerFactory", new String[0]), loggerTopic).build();
    }

    private MethodSpec generateConstructor(RegistryMetamodel registry, String registryClassName) {
        return MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).addStatement("final var names = $T.defaults().toRepo(dataSource.getTenant())", ClassName.bestGuess(registry.getTableClassName())).addStatement("this.registry = new $T(names, dataSource)", ClassName.bestGuess(registryClassName)).addStatement("this.dataSource = dataSource", new Object[0]).addStatement("this.tx = dataSource.getClient()", new Object[0]).addStatement("this.txLog = new $T()", StringBuilder.class).build();
    }

    private MethodSpec generateFromMethod(RegistryMetamodel registry, String builderInterfaceName) {
        return MethodSpec.methodBuilder("from").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(ClassName.bestGuess(builderInterfaceName + ".PersistenceUnit"), "unit", new Modifier[0]).returns(ClassName.bestGuess(builderInterfaceName)).addStatement("init.from(unit)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec generatePersistMethod(RegistryMetamodel registry, String builderInterfaceName, String persistenceUnitName, Map<String, OperationInfo> operations, List<TableMetamodel> tables) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("persist").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.bestGuess(persistenceUnitName)));
        method.addStatement("final var entries = init.build()", new Object[0]);
        method.addCode("\n", new Object[0]);
        method.addCode("return $T.combine().all()\n", ClassName.get(Uni.class));
        method.addCode("  .unis(\n", new Object[0]);
        ArrayList<CallSite> deleteOps = new ArrayList<CallSite>();
        ArrayList<CallSite> insertOps = new ArrayList<CallSite>();
        ArrayList<CallSite> updateOps = new ArrayList<CallSite>();
        List tablesByOrder = tables.stream().sorted((a, b) -> Integer.compare(a.getOrder(), b.getOrder())).toList();
        for (TableMetamodel table : tablesByOrder) {
            for (TableMetamodel.SqlMethod sqlMethod : table.getSqlMethods()) {
                String fieldName = this.buildOperationFieldName(table, sqlMethod.getType());
                if (fieldName == null || !operations.containsKey(fieldName)) continue;
                String visitCall = "visit" + NamingUtils.capitalize(fieldName) + "(entries)";
                switch (sqlMethod.getType()) {
                    case DELETE_ALL: {
                        deleteOps.add((CallSite)((Object)visitCall));
                        break;
                    }
                    case INSERT_ALL: {
                        insertOps.add((CallSite)((Object)visitCall));
                        break;
                    }
                    case UPDATE_ALL: {
                        updateOps.add((CallSite)((Object)visitCall));
                        break;
                    }
                }
            }
        }
        ArrayList<CallSite> visitCalls = new ArrayList<CallSite>();
        int orderNumber = 1;
        if (!deleteOps.isEmpty()) {
            method.addCode("    // === DELETE OPERATIONS ===\n", new Object[0]);
            for (String string : deleteOps) {
                visitCalls.add((CallSite)((Object)(string + ", // " + orderNumber++)));
            }
            method.addCode("    " + String.join((CharSequence)"\n    ", visitCalls) + "\n\n", new Object[0]);
            visitCalls.clear();
        }
        if (!insertOps.isEmpty()) {
            method.addCode("    // === INSERT OPERATIONS ===\n", new Object[0]);
            for (String string : insertOps) {
                visitCalls.add((CallSite)((Object)(string + ", // " + orderNumber++)));
            }
            method.addCode("    " + String.join((CharSequence)"\n    ", visitCalls) + "\n\n", new Object[0]);
            visitCalls.clear();
        }
        if (!updateOps.isEmpty()) {
            method.addCode("    // === UPDATE OPERATIONS ===\n", new Object[0]);
            for (int i = 0; i < updateOps.size(); ++i) {
                String string = (String)updateOps.get(i);
                boolean isLast = i == updateOps.size() - 1;
                visitCalls.add((CallSite)((Object)(string + (isLast ? " // " : ", // ") + orderNumber++)));
            }
            method.addCode("    " + String.join((CharSequence)"\n    ", visitCalls), new Object[0]);
        }
        method.addCode("\n  )\n", new Object[0]);
        method.addCode("  .with($T.class, (items) -> visitSuccess(entries, items))\n", ClassName.bestGuess(persistenceUnitName));
        method.addCode("  .onFailure($LException.class)\n", registry.getName() + "Builder");
        method.addStatement("  .recoverWithUni(this::visitError)", new Object[0]);
        return method.build();
    }

    private MethodSpec generateVisitMethod(RegistryMetamodel registry, String persistenceUnitName, String operationName, TableMetamodel table, TypeName entityType) {
        String methodName = "visit" + NamingUtils.capitalize(operationName);
        String getterName = "get" + NamingUtils.capitalize(operationName);
        TableMetamodel.SqlMethod sqlMethod = table.getSqlMethods().stream().filter(m -> this.buildOperationFieldName(table, m.getType()) != null).filter(m -> this.buildOperationFieldName(table, m.getType()).equals(operationName)).findFirst().orElseThrow(() -> new IllegalStateException("No SQL method found for operation: " + operationName));
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PRIVATE).addParameter(ClassName.bestGuess(persistenceUnitName), "entries", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.bestGuess(persistenceUnitName)));
        method.addStatement("final var data = entries.$L()", getterName);
        method.addStatement("final var sql = registry.$L().$L(data)", NamingUtils.pluralize(table.getTableName()), sqlMethod.getMethodName());
        method.addStatement("return visitExecution(sql, $T.class)", entityType);
        return method.build();
    }

    private MethodSpec generateVisitExecutionMethod(RegistryMetamodel registry, String persistenceUnitName) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("visitExecution").addModifiers(Modifier.PRIVATE).addParameter(ClassName.get(ThenaSqlClient.SqlTupleList.class), "sql", new Modifier[0]).addParameter(ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(Object.class)), "type", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.bestGuess(persistenceUnitName)));
        method.addStatement("visitTxLog(sql, type)", new Object[0]);
        method.addCode("\n", new Object[0]);
        method.addStatement("final var container = Immutable$L.builder()\n  .tenantId(this.dataSource.getTenant().getId())\n  .status($T.OK)\n  .log(\"\")\n  .build()", "PersistenceUnit", ClassName.get(BatchStatus.class));
        method.addCode("\n", new Object[0]);
        method.addCode("return $T.apply(tx, sql)\n", ClassName.get("io.resys.thena.storesql.support", "Execute", new String[0]));
        method.addCode("  .onItem().transform(row -> {\n", new Object[0]);
        method.addCode("    final var text = \"Inserted \" + (row == null ? 0 : row.rowCount()) + \" \" + type.getSimpleName() + \" entries\";\n", new Object[0]);
        method.addCode("    final var updatedMessages = new $T<>(container.getCommitLogs());\n", ArrayList.class);
        method.addCode("    updatedMessages.add($T.builder().text(text).build());\n", ClassName.get(ImmutableBatchLog.class));
        method.addCode("    return ($T) Immutable$L.builder().from(container)\n", ClassName.bestGuess(persistenceUnitName), "PersistenceUnit");
        method.addCode("      .commitLogs(updatedMessages)\n", new Object[0]);
        method.addCode("      .build();\n", new Object[0]);
        method.addCode("  })\n", new Object[0]);
        method.addCode("  .onFailure().transform(t -> {\n", new Object[0]);
        method.addCode("    final var text = \"Failed to insert \" + sql.getProps().size() + \" \" + type.getSimpleName() + \" entries\";\n", new Object[0]);
        method.addCode("    return new $LException(container, text, t);\n", registry.getName() + "Builder");
        method.addStatement("  })", new Object[0]);
        return method.build();
    }

    private MethodSpec generateVisitTxLogMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder("visitTxLog").addModifiers(Modifier.PRIVATE).addParameter(ClassName.get(ThenaSqlClient.SqlTupleList.class), "sql", new Modifier[0]).addParameter(ParameterizedTypeName.get(ClassName.get(Class.class), WildcardTypeName.subtypeOf(Object.class)), "type", new Modifier[0]);
        method.beginControlFlow("if(sql.getProps().isEmpty())", new Object[0]);
        method.addStatement("return", new Object[0]);
        method.endControlFlow();
        method.addCode("\n", new Object[0]);
        method.addStatement("this.txLog\n  .append($T.lineSeparator())\n  .append(\"--- processing \").append(sql.getProps().size()).append(\" entries of type: '\").append(type.getSimpleName()).append(\"'\")\n  .append(sql.getPropsDeepString()).append($T.lineSeparator())\n  .append(sql.getValue()).append($T.lineSeparator())", System.class, System.class, System.class);
        return method.build();
    }

    private MethodSpec generateVisitSuccessMethod(RegistryMetamodel registry, String persistenceUnitName) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("visitSuccess").addModifiers(Modifier.PRIVATE).addParameter(ClassName.bestGuess(persistenceUnitName), "inputContainer", new Modifier[0]).addParameter(ParameterizedTypeName.get(ClassName.get(List.class), ClassName.bestGuess(persistenceUnitName)), "items", new Modifier[0]).returns(ClassName.bestGuess(persistenceUnitName));
        method.addStatement("final var msg = $T.lineSeparator() + \"--- TX LOG\" + $T.lineSeparator() + txLog", System.class, System.class);
        method.beginControlFlow("if(log.isDebugEnabled())", new Object[0]);
        method.addStatement("log.debug(msg)", new Object[0]);
        method.endControlFlow();
        method.addCode("\n", new Object[0]);
        method.addStatement("return inputContainer.merge(items.stream()\n  .reduce((a, b) -> a.merge(b))\n  .orElse(inputContainer))", new Object[0]);
        return method.build();
    }

    private MethodSpec generateVisitErrorMethod(RegistryMetamodel registry, String persistenceUnitName) {
        String exceptionClassName = registry.getName() + "BuilderException";
        MethodSpec.Builder method = MethodSpec.methodBuilder("visitError").addModifiers(Modifier.PRIVATE).addParameter((Type)((Object)Throwable.class), "ex", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.bestGuess(persistenceUnitName)));
        method.addStatement("final var msg = $T.lineSeparator() + \"--- TX LOG\" + $T.lineSeparator() + txLog", System.class, System.class);
        method.addStatement("final var builderError = ($L) ex", exceptionClassName);
        method.addStatement("log.error(\"Failed to persist because of: {},\\r\\n{}\", ex.getMessage(), msg, ex)", new Object[0]);
        method.addCode("\n", new Object[0]);
        method.addStatement("return tx.rollback().onItem().transform(junk -> \n  Immutable$L.builder().from(builderError.getContainer())\n    .log(msg)\n    .build()\n)", "PersistenceUnit");
        return method.build();
    }

    private TypeSpec generateExceptionClass(RegistryMetamodel registry, String persistenceUnitName) {
        String exceptionClassName = registry.getName() + "BuilderException";
        TypeSpec.Builder exceptionClass = TypeSpec.classBuilder(exceptionClassName).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).superclass((Type)((Object)RuntimeException.class));
        exceptionClass.addField(FieldSpec.builder(ClassName.bestGuess(persistenceUnitName), "container", Modifier.PRIVATE, Modifier.FINAL).build());
        exceptionClass.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ClassName.bestGuess(persistenceUnitName), "container", new Modifier[0]).addParameter((Type)((Object)String.class), "message", new Modifier[0]).addParameter((Type)((Object)Throwable.class), "cause", new Modifier[0]).addStatement("super(message, cause)", new Object[0]).addStatement("this.container = container", new Object[0]).build());
        exceptionClass.addMethod(MethodSpec.methodBuilder("getContainer").addModifiers(Modifier.PUBLIC).returns(ClassName.bestGuess(persistenceUnitName)).addStatement("return container", new Object[0]).build());
        return exceptionClass.build();
    }

    private Map<String, OperationInfo> extractOperations(List<TableMetamodel> tables) {
        HashMap<String, OperationInfo> operations = new HashMap<String, OperationInfo>();
        for (TableMetamodel table : tables) {
            for (TableMetamodel.SqlMethod method : table.getSqlMethods()) {
                TypeName entityType;
                String fieldName = this.buildOperationFieldName(table, method.getType());
                if (fieldName == null || operations.containsKey(fieldName) || (entityType = this.extractEntityType(method)) == null) continue;
                operations.put(fieldName, new OperationInfo(table, entityType, method.getType()));
            }
        }
        return operations;
    }

    private String buildOperationFieldName(TableMetamodel table, TableMetamodel.SqlMethodType type) {
        String baseName = NamingUtils.toCamelCase(table.getTableName());
        return switch (type) {
            case TableMetamodel.SqlMethodType.INSERT_ALL -> baseName + "Inserts";
            case TableMetamodel.SqlMethodType.UPDATE_ALL -> baseName + "Updates";
            case TableMetamodel.SqlMethodType.DELETE_ALL -> baseName + "Deletes";
            default -> null;
        };
    }

    private TypeName extractEntityType(TableMetamodel.SqlMethod method) {
        if (method.getParameters().isEmpty()) {
            return null;
        }
        TableMetamodel.MethodParameter firstParam = method.getParameters().get(0);
        TypeName paramType = firstParam.getType();
        if (paramType instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)paramType;
            if (!parameterized.typeArguments.isEmpty()) {
                return parameterized.typeArguments.get(0);
            }
        }
        return paramType;
    }

    private static class OperationInfo {
        final TableMetamodel table;
        final TypeName entityType;
        final TableMetamodel.SqlMethodType methodType;

        OperationInfo(TableMetamodel table, TypeName entityType, TableMetamodel.SqlMethodType methodType) {
            this.table = table;
            this.entityType = entityType;
            this.methodType = methodType;
        }
    }
}

