/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.JavaFile;
import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.processor.codegen.Gen_Multi_BuilderImplementation;
import io.resys.thena.processor.codegen.Gen_Multi_BuilderInterface;
import io.resys.thena.processor.codegen.Gen_Multi_InternalTenantQuery;
import io.resys.thena.processor.codegen.Gen_Multi_QueryImplementation;
import io.resys.thena.processor.codegen.Gen_Multi_QueryInterface;
import io.resys.thena.processor.codegen.Gen_Multi_RegistryFactory;
import io.resys.thena.processor.codegen.Gen_Multi_TableNames;
import io.resys.thena.processor.codegen.Gen_Registry_DatabaseImplementation;
import io.resys.thena.processor.codegen.Gen_Registry_DatabaseInterface;
import io.resys.thena.processor.codegen.Gen_Registry_Exception;
import io.resys.thena.processor.codegen.Gen_Table_SqlImplementation;
import io.resys.thena.processor.model.Metamodel;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import io.resys.thena.processor.spi.RegistryCodeGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class SqlAnnotationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(TenantSql.Table.class.getCanonicalName(), TenantSql.Registry.class.getCanonicalName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Metamodel metaModel = Metamodel.builder(this.processingEnv).addAllRegistries(roundEnv.getElementsAnnotatedWith(TenantSql.Registry.class)).addAllTables(roundEnv.getElementsAnnotatedWith(TenantSql.Table.class)).build();
        for (TableMetamodel table : metaModel.getTables()) {
            RegistryMetamodel registry = metaModel.findRegistryForTable(table);
            if (registry == null) continue;
            try {
                this.processTableInterface(table, registry, metaModel);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process table " + table.getTableName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        for (RegistryMetamodel registry : metaModel.getRegistries()) {
            List<TableMetamodel> tables = metaModel.getTablesForRegistry(registry);
            try {
                this.processRegistry(registry, tables);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process registry " + registry.getName() + ": " + e.getMessage(), registry.getElement());
                e.printStackTrace();
            }
        }
        return true;
    }

    private void processRegistry(RegistryMetamodel registryConfig, List<TableMetamodel> tableModels) throws IOException {
        JavaFile javaFile;
        if (tableModels.isEmpty()) {
            return;
        }
        List<TableMetamodel> filteredTables = tableModels;
        List<Gen_Registry_Exception> registryGenerators = List.of(new Gen_Registry_DatabaseInterface(), new Gen_Registry_DatabaseImplementation(), new Gen_Registry_Exception());
        List<Gen_Multi_QueryImplementation> multiTableGenerators = List.of(new Gen_Multi_TableNames(), new Gen_Multi_RegistryFactory(), new Gen_Multi_QueryInterface(), new Gen_Multi_BuilderInterface(), new Gen_Multi_InternalTenantQuery(), new Gen_Multi_BuilderImplementation(), new Gen_Multi_QueryImplementation());
        for (RegistryCodeGenerator registryCodeGenerator : registryGenerators) {
            javaFile = registryCodeGenerator.generate(registryConfig);
            javaFile.writeTo(this.processingEnv.getFiler());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated: " + javaFile.typeSpec.name + " using " + registryCodeGenerator.getClass().getSimpleName());
        }
        for (MultiTableCodeGenerator multiTableCodeGenerator : multiTableGenerators) {
            javaFile = multiTableCodeGenerator.generate(registryConfig, filteredTables);
            javaFile.writeTo(this.processingEnv.getFiler());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated: " + javaFile.typeSpec.name + " using " + multiTableCodeGenerator.getClass().getSimpleName() + " with " + filteredTables.size() + " tables");
        }
    }

    private void processTableInterface(TableMetamodel model, RegistryMetamodel registry, Metamodel metaModel) throws IOException {
        Gen_Table_SqlImplementation codeGenerator = new Gen_Table_SqlImplementation(metaModel);
        JavaFile javaFile = codeGenerator.generate(model, registry);
        javaFile.writeTo(this.processingEnv.getFiler());
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated: " + javaFile.typeSpec.name + " using " + codeGenerator.getClass().getSimpleName());
    }
}

