/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import io.resys.thena.api.entities.ImmutableTenant;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.datasource.TenantContext;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import java.util.Optional;

public class ThenaSqlDataSourceImpl
implements ThenaSqlDataSource {
    private final Tenant tenant;
    private final TenantContext tenantTableNames;
    private final ThenaSqlClient.ThenaSqlPool pool;
    private final ThenaSqlDataSourceErrorHandler errorHandler;
    private final Optional<ThenaSqlClient> tx;
    private final boolean isTenantLoaded;
    private final ThenaSqlDataSource.TenantCache tenantCache;

    public ThenaSqlDataSourceImpl(Tenant tenant, TenantContext tenantTableNames, ThenaSqlClient.ThenaSqlPool pool, ThenaSqlDataSourceErrorHandler errorHandler, Optional<ThenaSqlClient> tx, ThenaSqlDataSource.TenantCache tenantCache) {
        this.tenant = tenant;
        this.tenantTableNames = tenantTableNames.withTenant(tenant);
        this.errorHandler = errorHandler;
        this.pool = pool;
        this.tx = tx;
        this.isTenantLoaded = !tenant.getId().equals("") && !tenant.getPrefix().equals("");
        this.tenantCache = tenantCache;
    }

    public ThenaSqlDataSourceImpl(String tenant, TenantContext tenantTableNames, ThenaSqlClient.ThenaSqlPool pool, ThenaSqlDataSourceErrorHandler errorHandler, Optional<ThenaSqlClient> tx, ThenaSqlDataSource.TenantCache tenantCache) {
        this.tenantCache = tenantCache;
        this.isTenantLoaded = false;
        this.tenant = ImmutableTenant.builder().name(tenant).type(Tenant.StructureType.git).id("").rev("").prefix("").build();
        this.tenantTableNames = tenantTableNames.withTenant(this.tenant);
        this.errorHandler = errorHandler;
        this.pool = pool;
        this.tx = tx;
    }

    @Override
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    public TenantContext getTenantContext() {
        return this.tenantTableNames;
    }

    @Override
    public ThenaSqlClient.ThenaSqlPool getPool() {
        return this.pool;
    }

    @Override
    public ThenaSqlDataSourceErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Optional<ThenaSqlClient> getTx() {
        return this.tx;
    }

    @Override
    public ThenaSqlDataSource withTenant(Tenant tenant) {
        return new ThenaSqlDataSourceImpl(tenant, this.tenantTableNames, this.pool, this.errorHandler, this.tx, this.tenantCache);
    }

    @Override
    public boolean isLocked(Throwable t) {
        return this.errorHandler.isLocked(t);
    }

    @Override
    public ThenaSqlDataSource withTx(ThenaSqlClient tx) {
        return new ThenaSqlDataSourceImpl(this.tenant, this.tenantTableNames, this.pool, this.errorHandler, Optional.of(tx), this.tenantCache);
    }

    @Override
    public boolean isTenantLoaded() {
        return this.isTenantLoaded;
    }

    @Override
    public TenantContext getRegistry() {
        return this.tenantTableNames;
    }

    @Override
    public ThenaSqlDataSource.TenantCache getTenantCache() {
        return this.tenantCache;
    }
}

