/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.Tuple;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.immutables.value.Value;

public interface ThenaSqlClient {
    public Uni<Void> rollback();

    public ThenaPreparedQuery<RowSet<Row>> preparedQuery(String var1);

    public ThenaQuery<RowSet<Row>> query(String var1);

    public static String getPropsDeepString(Tuple props) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            Object value = props.getValue(i);
            if (value != null && value.getClass().isArray()) {
                List<String> unwrapped = Arrays.asList((Object[])value).stream().map(e -> Optional.ofNullable(e).map(x -> x.toString()).orElse(null)).toList();
                sb.append("[").append(String.join((CharSequence)",", unwrapped)).append("]");
            } else {
                sb.append(value);
            }
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Value.Immutable
    public static interface SqlTupleList {
        public String getValue();

        public List<Tuple> getProps();

        default public ThenaSqlDataSourceErrorHandler.SqlTupleListFailed failed(Throwable t, String message, Object ... args) {
            return new ThenaSqlDataSourceErrorHandler.SqlTupleListFailed(message.formatted(args), this, t);
        }

        default public String getPropsDeepString() {
            StringBuilder sb = new StringBuilder(System.lineSeparator());
            sb.append("---");
            int size = this.getProps().size();
            for (int i = 0; i < size; ++i) {
                sb.append(System.lineSeparator()).append("--- ").append(i).append(": ").append(ThenaSqlClient.getPropsDeepString(this.getProps().get(i)));
            }
            sb.append(System.lineSeparator()).append("---");
            return sb.toString();
        }
    }

    @Value.Immutable
    public static interface SqlTuple {
        public String getValue();

        public Tuple getProps();

        @Nullable
        public TenantSql.RowMapper<?> getRowMapper();

        default public String getPropsDeepString() {
            return ThenaSqlClient.getPropsDeepString(this.getProps());
        }

        default public ThenaSqlDataSourceErrorHandler.SqlTupleFailed failed(Throwable t, String message, Object ... args) {
            return new ThenaSqlDataSourceErrorHandler.SqlTupleFailed(message.formatted(args), this, t);
        }
    }

    @Value.Immutable
    public static interface Sql {
        public String getValue();

        @Nullable
        public TenantSql.RowMapper<?> getRowMapper();

        default public ThenaSqlDataSourceErrorHandler.SqlFailed failed(Throwable t, String message, Object ... args) {
            return new ThenaSqlDataSourceErrorHandler.SqlFailed(message.formatted(args), this, t);
        }
    }

    public static interface ThenaSqlPool
    extends ThenaSqlClient {
        public <T> Uni<T> withTransaction(Function<ThenaSqlClient, Uni<T>> var1);
    }

    public static interface ThenaPreparedQuery<T>
    extends ThenaQuery<T> {
        @Override
        public <U> ThenaPreparedQuery<RowSet<U>> mapping(Function<Row, U> var1);

        @Override
        public Uni<T> execute();

        public Uni<T> execute(Tuple var1);

        public Uni<T> executeBatch(List<Tuple> var1);
    }

    public static interface ThenaQuery<T> {
        public <U> ThenaQuery<RowSet<U>> mapping(Function<Row, U> var1);

        public Uni<T> execute();
    }
}

