/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import io.resys.thena.api.entities.Tenant;
import io.resys.thena.datasource.ImmutableTenantContext;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TenantContext {
    public abstract String getDb();

    public abstract String getTenant();

    public abstract String getPrefix();

    public TenantContext withTenant(Tenant repo) {
        String prefix = repo.getPrefix();
        return this.withTenantPrefix(prefix);
    }

    public TenantContext withTenantPrefix(String prefix) {
        return ImmutableTenantContext.builder().db(this.getDb()).tenant(this.getTenant()).prefix(prefix).build();
    }

    public static TenantContext defaults(String db) {
        return ImmutableTenantContext.builder().db(db == null ? "docdb" : db).tenant("tenants").prefix("").build();
    }

    public static interface WithTenant<T extends WithTenant<T>> {
        public T withTenant(TenantContext var1);
    }
}

