/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.datasource.ThenaSqlDataSource;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCacheImpl
implements ThenaSqlDataSource.TenantCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantCacheImpl.class);
    private final Cache<String, Tenant> tenants_by_id;

    public TenantCacheImpl() {
        this.tenants_by_id = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofDays(1L)).build();
        log.info("Tenant cache created with caffeine, expire after writing: 1 day");
    }

    public TenantCacheImpl(Cache<String, Tenant> preconfigured) {
        this.tenants_by_id = preconfigured;
        log.info("Tenant cache created with caffeine, with user configuration");
    }

    @Override
    public Optional<Tenant> getTenant(String idOrName) {
        Tenant result = this.tenants_by_id.getIfPresent(idOrName);
        if (result != null) {
            log.debug("Tenant by id: {} found from cache", (Object)idOrName);
            return Optional.of(result);
        }
        Optional<Tenant> found = this.tenants_by_id.asMap().values().stream().filter(entry -> {
            if (entry.getId().equals(idOrName)) {
                log.debug("Tenant by id: {} found from cache", (Object)idOrName);
                return true;
            }
            if (entry.getExternalId() != null && entry.getExternalId().equals(idOrName)) {
                log.debug("Tenant by external id: {} found from cache", (Object)idOrName);
                return true;
            }
            if (entry.getName().equals(idOrName)) {
                log.debug("Tenant by name: {} found from cache", (Object)idOrName);
                return true;
            }
            return false;
        }).findFirst();
        if (found.isEmpty()) {
            log.debug("Tenant '{}' not found from cache", (Object)idOrName);
        }
        return found;
    }

    @Override
    public void setTenant(Tenant tenant) {
        if (tenant == null) {
            log.warn("Null tenant passed to cache, ignoring it...");
        } else {
            this.tenants_by_id.put(tenant.getId(), tenant);
        }
    }

    @Override
    public void invalidateAll() {
        this.tenants_by_id.invalidateAll();
    }
}

