/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.datasource.TenantContext;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TenantContext", generator="Immutables")
public final class ImmutableTenantContext
extends TenantContext {
    private final String db;
    private final String tenant;
    private final String prefix;

    private ImmutableTenantContext(String db, String tenant, String prefix) {
        this.db = db;
        this.tenant = tenant;
        this.prefix = prefix;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public final ImmutableTenantContext withDb(String value) {
        String newValue = Objects.requireNonNull(value, "db");
        if (this.db.equals(newValue)) {
            return this;
        }
        return new ImmutableTenantContext(newValue, this.tenant, this.prefix);
    }

    public final ImmutableTenantContext withTenant(String value) {
        String newValue = Objects.requireNonNull(value, "tenant");
        if (this.tenant.equals(newValue)) {
            return this;
        }
        return new ImmutableTenantContext(this.db, newValue, this.prefix);
    }

    public final ImmutableTenantContext withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return new ImmutableTenantContext(this.db, this.tenant, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenantContext && this.equalsByValue((ImmutableTenantContext)another);
    }

    private boolean equalsByValue(ImmutableTenantContext another) {
        return this.db.equals(another.db) && this.tenant.equals(another.tenant) && this.prefix.equals(another.prefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.prefix.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TenantContext").omitNullValues().add("db", this.db).add("tenant", this.tenant).add("prefix", this.prefix).toString();
    }

    public static ImmutableTenantContext copyOf(TenantContext instance) {
        if (instance instanceof ImmutableTenantContext) {
            return (ImmutableTenantContext)instance;
        }
        return ImmutableTenantContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TenantContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_TENANT = 2L;
        private static final long INIT_BIT_PREFIX = 4L;
        private long initBits = 7L;
        private String db;
        private String tenant;
        private String prefix;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TenantContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.getDb());
            this.tenant(instance.getTenant());
            this.prefix(instance.getPrefix());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(String db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tenant(String tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTenantContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTenantContext(this.db, this.tenant, this.prefix);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("prefix");
            }
            return "Cannot build TenantContext, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

