/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.datasource.ThenaSqlClient;
import io.vertx.mutiny.sqlclient.Tuple;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ThenaSqlClient.SqlTuple", generator="Immutables")
public final class ImmutableSqlTuple
implements ThenaSqlClient.SqlTuple {
    private final String value;
    private final Tuple props;
    @Nullable
    private final TenantSql.RowMapper<?> rowMapper;

    private ImmutableSqlTuple(String value, Tuple props, @Nullable TenantSql.RowMapper<?> rowMapper) {
        this.value = value;
        this.props = props;
        this.rowMapper = rowMapper;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Tuple getProps() {
        return this.props;
    }

    @Override
    @Nullable
    public TenantSql.RowMapper<?> getRowMapper() {
        return this.rowMapper;
    }

    public final ImmutableSqlTuple withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlTuple(newValue, this.props, this.rowMapper);
    }

    public final ImmutableSqlTuple withProps(Tuple value) {
        if (this.props == value) {
            return this;
        }
        Tuple newValue = Objects.requireNonNull(value, "props");
        return new ImmutableSqlTuple(this.value, newValue, this.rowMapper);
    }

    public final ImmutableSqlTuple withRowMapper(@Nullable TenantSql.RowMapper<?> value) {
        if (this.rowMapper == value) {
            return this;
        }
        return new ImmutableSqlTuple(this.value, this.props, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlTuple && this.equalsByValue((ImmutableSqlTuple)another);
    }

    private boolean equalsByValue(ImmutableSqlTuple another) {
        return this.value.equals(another.value) && this.props.equals(another.props) && Objects.equals(this.rowMapper, another.rowMapper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.props.hashCode();
        h += (h << 5) + Objects.hashCode(this.rowMapper);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlTuple").omitNullValues().add("value", this.value).add("props", this.props).add("rowMapper", this.rowMapper).toString();
    }

    public static ImmutableSqlTuple copyOf(ThenaSqlClient.SqlTuple instance) {
        if (instance instanceof ImmutableSqlTuple) {
            return (ImmutableSqlTuple)instance;
        }
        return ImmutableSqlTuple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThenaSqlClient.SqlTuple", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_PROPS = 2L;
        private long initBits = 3L;
        private String value;
        private Tuple props;
        private TenantSql.RowMapper<?> rowMapper;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ThenaSqlClient.SqlTuple instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.props(instance.getProps());
            TenantSql.RowMapper<?> rowMapperValue = instance.getRowMapper();
            if (rowMapperValue != null) {
                this.rowMapper(rowMapperValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder props(Tuple props) {
            this.props = Objects.requireNonNull(props, "props");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowMapper(@Nullable TenantSql.RowMapper<?> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        public ImmutableSqlTuple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlTuple(this.value, this.props, this.rowMapper);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("props");
            }
            return "Cannot build SqlTuple, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

