/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.datasource;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.datasource.ThenaSqlClient;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ThenaSqlClient.Sql", generator="Immutables")
public final class ImmutableSql
implements ThenaSqlClient.Sql {
    private final String value;
    @Nullable
    private final TenantSql.RowMapper<?> rowMapper;

    private ImmutableSql(String value, @Nullable TenantSql.RowMapper<?> rowMapper) {
        this.value = value;
        this.rowMapper = rowMapper;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public TenantSql.RowMapper<?> getRowMapper() {
        return this.rowMapper;
    }

    public final ImmutableSql withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableSql(newValue, this.rowMapper);
    }

    public final ImmutableSql withRowMapper(@Nullable TenantSql.RowMapper<?> value) {
        if (this.rowMapper == value) {
            return this;
        }
        return new ImmutableSql(this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSql && this.equalsByValue((ImmutableSql)another);
    }

    private boolean equalsByValue(ImmutableSql another) {
        return this.value.equals(another.value) && Objects.equals(this.rowMapper, another.rowMapper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.rowMapper);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Sql").omitNullValues().add("value", this.value).add("rowMapper", this.rowMapper).toString();
    }

    public static ImmutableSql copyOf(ThenaSqlClient.Sql instance) {
        if (instance instanceof ImmutableSql) {
            return (ImmutableSql)instance;
        }
        return ImmutableSql.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThenaSqlClient.Sql", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private String value;
        private TenantSql.RowMapper<?> rowMapper;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ThenaSqlClient.Sql instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            TenantSql.RowMapper<?> rowMapperValue = instance.getRowMapper();
            if (rowMapperValue != null) {
                this.rowMapper(rowMapperValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowMapper(@Nullable TenantSql.RowMapper<?> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        public ImmutableSql build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSql(this.value, this.rowMapper);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Sql, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

