/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.api.envelope;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.api.envelope.Message;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Message", generator="Immutables")
public final class ImmutableMessage
implements Message {
    private final String text;
    @Nullable
    private final Throwable exception;

    private ImmutableMessage(String text, @Nullable Throwable exception) {
        this.text = text;
        this.exception = exception;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public final ImmutableMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableMessage(newValue, this.exception);
    }

    public final ImmutableMessage withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new ImmutableMessage(this.text, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessage && this.equalsByValue((ImmutableMessage)another);
    }

    private boolean equalsByValue(ImmutableMessage another) {
        return this.text.equals(another.text) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Message").omitNullValues().add("text", this.text).add("exception", this.exception).toString();
    }

    public static ImmutableMessage copyOf(Message instance) {
        if (instance instanceof ImmutableMessage) {
            return (ImmutableMessage)instance;
        }
        return ImmutableMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Message", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        private String text;
        private Throwable exception;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.text(instance.getText());
            Throwable exceptionValue = instance.getException();
            if (exceptionValue != null) {
                this.exception(exceptionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ImmutableMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessage(this.text, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build Message, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

