/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.api.entities;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.api.entities.Tenant;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Tenant", generator="Immutables")
public final class ImmutableTenant
implements Tenant {
    private final String id;
    private final String rev;
    private final String prefix;
    private final String name;
    @Nullable
    private final String externalId;
    private final Tenant.StructureType type;

    private ImmutableTenant(String id, String rev, String prefix, String name, @Nullable String externalId, Tenant.StructureType type) {
        this.id = id;
        this.rev = rev;
        this.prefix = prefix;
        this.name = name;
        this.externalId = externalId;
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRev() {
        return this.rev;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public Tenant.StructureType getType() {
        return this.type;
    }

    public final ImmutableTenant withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTenant(newValue, this.rev, this.prefix, this.name, this.externalId, this.type);
    }

    public final ImmutableTenant withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (this.rev.equals(newValue)) {
            return this;
        }
        return new ImmutableTenant(this.id, newValue, this.prefix, this.name, this.externalId, this.type);
    }

    public final ImmutableTenant withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return new ImmutableTenant(this.id, this.rev, newValue, this.name, this.externalId, this.type);
    }

    public final ImmutableTenant withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTenant(this.id, this.rev, this.prefix, newValue, this.externalId, this.type);
    }

    public final ImmutableTenant withExternalId(@Nullable String value) {
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ImmutableTenant(this.id, this.rev, this.prefix, this.name, value, this.type);
    }

    public final ImmutableTenant withType(Tenant.StructureType value) {
        Tenant.StructureType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableTenant(this.id, this.rev, this.prefix, this.name, this.externalId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenant && this.equalsByValue((ImmutableTenant)another);
    }

    private boolean equalsByValue(ImmutableTenant another) {
        return this.id.equals(another.id) && this.rev.equals(another.rev) && this.prefix.equals(another.prefix) && this.name.equals(another.name) && Objects.equals(this.externalId, another.externalId) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rev.hashCode();
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Tenant").omitNullValues().add("id", this.id).add("rev", this.rev).add("prefix", this.prefix).add("name", this.name).add("externalId", this.externalId).add("type", (Object)this.type).toString();
    }

    public static ImmutableTenant copyOf(Tenant instance) {
        if (instance instanceof ImmutableTenant) {
            return (ImmutableTenant)instance;
        }
        return ImmutableTenant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tenant", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REV = 2L;
        private static final long INIT_BIT_PREFIX = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        private String id;
        private String rev;
        private String prefix;
        private String name;
        private String externalId;
        private Tenant.StructureType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tenant instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rev(instance.getRev());
            this.prefix(instance.getPrefix());
            this.name(instance.getName());
            String externalIdValue = instance.getExternalId();
            if (externalIdValue != null) {
                this.externalId(externalIdValue);
            }
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Tenant.StructureType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTenant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTenant(this.id, this.rev, this.prefix, this.name, this.externalId, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rev");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("prefix");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Tenant, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

