/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.api.envelope.Message;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TenantActions.TenantCommitResult", generator="Immutables")
public final class ImmutableTenantCommitResult
implements TenantActions.TenantCommitResult {
    @Nullable
    private final Tenant repo;
    private final TenantActions.CommitStatus status;
    private final ImmutableList<Message> messages;

    private ImmutableTenantCommitResult(@Nullable Tenant repo, TenantActions.CommitStatus status, ImmutableList<Message> messages) {
        this.repo = repo;
        this.status = status;
        this.messages = messages;
    }

    @Override
    @Nullable
    public Tenant getRepo() {
        return this.repo;
    }

    @Override
    public TenantActions.CommitStatus getStatus() {
        return this.status;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableTenantCommitResult withRepo(@Nullable Tenant value) {
        if (this.repo == value) {
            return this;
        }
        return new ImmutableTenantCommitResult(value, this.status, this.messages);
    }

    public final ImmutableTenantCommitResult withStatus(TenantActions.CommitStatus value) {
        TenantActions.CommitStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableTenantCommitResult(this.repo, newValue, this.messages);
    }

    public final ImmutableTenantCommitResult withMessages(Message ... elements) {
        ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTenantCommitResult(this.repo, this.status, newValue);
    }

    public final ImmutableTenantCommitResult withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTenantCommitResult(this.repo, this.status, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenantCommitResult && this.equalsByValue((ImmutableTenantCommitResult)another);
    }

    private boolean equalsByValue(ImmutableTenantCommitResult another) {
        return Objects.equals(this.repo, another.repo) && this.status.equals((Object)another.status) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repo);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TenantCommitResult").omitNullValues().add("repo", this.repo).add("status", (Object)this.status).add("messages", this.messages).toString();
    }

    public static ImmutableTenantCommitResult copyOf(TenantActions.TenantCommitResult instance) {
        if (instance instanceof ImmutableTenantCommitResult) {
            return (ImmutableTenantCommitResult)instance;
        }
        return ImmutableTenantCommitResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TenantActions.TenantCommitResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private long initBits = 1L;
        private Tenant repo;
        private TenantActions.CommitStatus status;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TenantActions.TenantCommitResult instance) {
            Objects.requireNonNull(instance, "instance");
            Tenant repoValue = instance.getRepo();
            if (repoValue != null) {
                this.repo(repoValue);
            }
            this.status(instance.getStatus());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(@Nullable Tenant repo) {
            this.repo = repo;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(TenantActions.CommitStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message ... elements) {
            this.messages.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableTenantCommitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTenantCommitResult(this.repo, this.status, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build TenantCommitResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

