/*
 * Decompiled with CFR 0.152.
 */
package io.digiexpress.eveli.app.authorization;

import io.digiexpress.eveli.client.api.AuthClient;
import io.digiexpress.eveli.client.api.CrmClient;
import io.digiexpress.eveli.client.spi.auth.SpringSecurityPolicy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;

@Configuration
public class AuthorizationConfig {
    @Bean
    public SecurityFilterChain workerSecurity(HttpSecurity http, AuthorizationManager<RequestAuthorizationContext> auth, AuthenticationManager authenticationManager) throws Exception {
        return (SecurityFilterChain)http.securityMatchers(matcher -> matcher.requestMatchers(new String[]{"/worker/**"})).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).access(auth)).csrf(t -> t.disable()).httpBasic(Customizer.withDefaults()).formLogin(form -> form.loginPage("/login-worker").permitAll()).authenticationManager(authenticationManager).build();
    }

    @Bean
    public SecurityFilterChain portalSecurity(HttpSecurity http, AuthorizationManager<RequestAuthorizationContext> auth, AuthenticationManager authenticationManager) throws Exception {
        return (SecurityFilterChain)http.securityMatchers(matcher -> matcher.requestMatchers(new String[]{"/portal/secured/**"})).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).access(auth)).csrf(t -> t.disable()).httpBasic(Customizer.withDefaults()).formLogin(form -> form.loginPage("/login-customer").permitAll()).authenticationManager(authenticationManager).build();
    }

    @Bean
    public SpringSecurityPolicy authorization(AuthClient auth, CrmClient crm) {
        return new SpringSecurityPolicy(auth, crm);
    }
}

