/*
 * Decompiled with CFR 0.152.
 */
package io.digiexpress.eveli.app;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.digiexpress.eveli.assets.api.EveliAssetClient;
import io.digiexpress.eveli.assets.api.EveliAssetComposer;
import io.digiexpress.eveli.assets.spi.builders.DeploymentImporter;
import io.digiexpress.eveli.client.config.EveliContext;
import io.digiexpress.eveli.client.config.EveliPropsAssets;
import io.digiexpress.eveli.dialob.api.DialobClient;
import io.resys.hdes.client.api.HdesClient;
import io.thestencil.client.api.StencilClient;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"init"})
public class ImportAssetsConfig {
    @Autowired
    EveliPropsAssets config;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    DialobClient dialobClient;
    @Autowired
    EveliContext eveliContext;

    @GetMapping
    public ResponseEntity<String> initAssets() throws StreamReadException, DatabindException, IOException {
        EveliAssetComposer.Deployment importData = (EveliAssetComposer.Deployment)this.objectMapper.readValue(new File(this.config.getImportDeployment()), EveliAssetComposer.Deployment.class);
        HdesClient wrench = this.eveliContext.getWrench();
        StencilClient stencil = this.eveliContext.getStencil();
        EveliAssetClient eveliAssets = this.eveliContext.getAssets();
        new DeploymentImporter(this.dialobClient, wrench, stencil, eveliAssets).importData(importData).await().atMost(Duration.ofMinutes(5L));
        return ResponseEntity.ok((Object)"imported");
    }
}

