/*
 * Decompiled with CFR 0.152.
 */
package io.digiexpress.eveli.app;

import io.digiexpress.eveli.app.ApplicationConfigLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationConfigLogger {
    private static final String LN = "\r\n";
    private final List<LogEntry> entries = new ArrayList();
    private final Set<String> log_entry_paths = new HashSet();
    private final StringBuilder log_msg = new StringBuilder("\r\n");
    private final String greenColor = "\u001b[32m";
    private final String yellowColor = "\u001b[33m";
    private final String magentaColor = "\u001b[35m";
    private final String resetColor = "\u001b[0m";

    public String log(RequestMappingHandlerMapping mapping) {
        Map endpoints = mapping.getHandlerMethods();
        endpoints.forEach((key, value) -> this.createLogEntry(key, value));
        this.createSummary();
        this.createGroupedLogEntries();
        return this.log_msg.toString();
    }

    private void createSummary() {
        long httpGETCount = this.entries.stream().filter(entry -> entry.getMethods().contains("GET")).count();
        long httpPUTCount = this.entries.stream().filter(entry -> entry.getMethods().toString().contains("PUT")).count();
        long httpPOSTCount = this.entries.stream().filter(entry -> entry.getMethods().toString().contains("POST")).count();
        long httpDELETECount = this.entries.stream().filter(entry -> entry.getMethods().toString().contains("DELETE")).count();
        this.log_msg.append("#-----------------------------------------------------------").append("\r\n").append("  Summary:").append("\r\n").append("    Total-endpoints: ").append(this.entries.size()).append("\r\n").append("    Total-GET: ").append(httpGETCount).append("\r\n").append("    Total-PUT: ").append(httpPUTCount).append("\r\n").append("    Total-POST: ").append(httpPOSTCount).append("\r\n").append("    Total-DELETE: ").append(httpDELETECount).append("\r\n").append("#-----------------------------------------------------------").append("\r\n");
    }

    private void createLogEntry(RequestMappingInfo mappingInfo, HandlerMethod method) {
        String pattern = mappingInfo.getActivePatternsCondition().toString();
        LogEntry entry = LogEntry.builder().controller(method.getBeanType().getSimpleName()).path(pattern.substring(1, pattern.length() - 1)).methods(mappingInfo.getMethodsCondition().getMethods().stream().map(m -> m.name()).toList()).build();
        this.entries.add(entry);
        this.log_entry_paths.add(entry.getPath());
    }

    private List<String> extractGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        for (LogEntry control : this.entries) {
            String[] controlSegments = control.getPath().split("\\/");
            for (LogEntry test : this.entries) {
                String groupKey;
                if (test.getPath().equals(control.getPath()) || StringUtils.isEmpty((CharSequence)(groupKey = this.getGroup(controlSegments, test.getPath()))) || groups.contains(groupKey)) continue;
                groups.add(groupKey);
            }
        }
        return groups.stream().filter(endpoint -> this.entries.stream().filter(e -> e.getPath().equals(endpoint)).count() == 0L || endpoint.split("\\/").length == 2).sorted().toList();
    }

    private String getGroup(String[] control, String test) {
        StringBuilder longestCommon = new StringBuilder();
        for (String common : control) {
            String next = longestCommon.toString() + "/" + common;
            if (!test.startsWith(next) && longestCommon.length() > 1) break;
            if (!longestCommon.toString().endsWith("/")) {
                longestCommon.append("/");
            }
            longestCommon.append(common);
        }
        return longestCommon.toString();
    }

    private void createGroupedLogEntries() {
        List allGroups = this.extractGroups();
        for (String groupPath : allGroups) {
            this.log_msg.append("  ").append(groupPath).append(":").append("\r\n");
            this.entries.stream().filter(e -> allGroups.stream().filter(longer -> longer.length() > groupPath.length()).filter(longer -> e.getPath().startsWith((String)longer)).findFirst().isEmpty()).filter(e -> e.getPath().startsWith(groupPath)).forEach(entry -> this.log_msg.append("\u001b[32m").append("    ").append(entry.getPath()).append("\u001b[0m").append(" ").append("\u001b[33m").append(entry.getMethods().toString()).append("\u001b[0m").append("\u001b[35m").append(": ").append(entry.getController()).append("\u001b[0m").append("\r\n"));
        }
    }
}

