/*
 * Decompiled with CFR 0.152.
 */
package io.digiexpress.eveli.app;

import io.digiexpress.eveli.app.ApplicationConfigLogger;
import io.digiexpress.eveli.client.config.EveliAutoConfig;
import io.digiexpress.eveli.client.config.EveliAutoConfigAssets;
import io.digiexpress.eveli.client.config.EveliAutoConfigDB;
import io.digiexpress.eveli.client.config.EveliAutoConfigGamut;
import io.digiexpress.eveli.client.config.EveliAutoConfigWorker;
import io.digiexpress.eveli.dialob.config.DialobAutoConfig;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.socket.config.annotation.EnableWebSocket;

@EnableWebSocket
@EnableWebSecurity
@SpringBootApplication
@EnableAutoConfiguration
@EnableAsync
@EnableScheduling
@Import(value={EveliAutoConfigDB.class, EveliAutoConfigAssets.class, EveliAutoConfig.class, DialobAutoConfig.class, EveliAutoConfigGamut.class, EveliAutoConfigWorker.class})
public class Application {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws Exception {
        SpringApplication.run((Class[])new Class[]{Application.class}, (String[])args);
    }

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        String newLog = new ApplicationConfigLogger().log(requestMappingHandlerMapping);
        log.info(newLog);
    }
}

