/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cache;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.cache.QuestionnaireSessionCache;
import io.dialob.integration.api.event.FormUpdatedEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;

public class ScheduledSessionEvictionPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledSessionEvictionPolicy.class);
    private final QuestionnaireSessionCache cache;
    private final Function<QuestionnaireSession, QuestionnaireSession> sessionEvictionCallback;
    private final Optional<CacheManager> cacheManager;
    private final Integer ttl;

    public ScheduledSessionEvictionPolicy(QuestionnaireSessionCache cache, Function<QuestionnaireSession, QuestionnaireSession> sessionEvictionCallback, Optional<CacheManager> cacheManager, Integer ttl) {
        this.cache = cache;
        this.sessionEvictionCallback = Objects.requireNonNullElseGet(sessionEvictionCallback, Function::identity);
        this.cacheManager = cacheManager;
        this.ttl = ttl != null ? ttl : 60000;
    }

    @Scheduled(fixedRateString="${dialob.session.cache.evict-rate:2000}")
    public void evictQuietSessions() {
        LOGGER.debug("evictQuietSessions");
        Instant now = Instant.now();
        this.evictWhen(session -> session.getStatus() == Questionnaire.Metadata.Status.COMPLETED || Duration.between(session.getLastUpdate(), now).toMillis() > (long)this.ttl.intValue());
    }

    protected void evictWhen(Predicate<QuestionnaireSession> evictCondition) {
        HashSet sessionsToEvict = new HashSet();
        this.cache.forEach(session -> {
            if (evictCondition.test((QuestionnaireSession)session)) {
                session.getSessionId().ifPresent(sessionsToEvict::add);
            }
        });
        sessionsToEvict.forEach(this::evict);
    }

    protected void evict(String sessionId) {
        this.cache.evict(sessionId, this.sessionEvictionCallback);
    }

    @EventListener
    protected void onFormUpdatedEvent(FormUpdatedEvent event) {
        LOGGER.debug("onFormUpdatedEvent({})", (Object)event);
        String formId = event.getFormId();
        this.evictWhen(session -> session.usesLastestFormRevision() && formId.equals(session.getFormId()));
        this.cacheManager.flatMap(cacheManager -> Optional.ofNullable(cacheManager.getCache("dialobProgramsCache"))).ifPresent(programCache -> programCache.evict((Object)formId));
    }
}

