/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.cache.LocalQuestionnaireSessionCache;
import io.dialob.cache.QuestionnaireSessionCache;
import io.dialob.cache.ScheduledSessionEvictionPolicy;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.settings.DialobSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.support.CompositeCacheManager;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DialobSettings.class})
public class DialobCacheAutoConfiguration {
    @Bean(name={"dialobProgramsCacheManager"})
    public CacheManager dialobProgramsCacheManager() {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager(new String[]{"dialobProgramsCache"});
        caffeineCacheManager.setCaffeine(Caffeine.newBuilder().maximumSize(100L));
        caffeineCacheManager.setAllowNullValues(false);
        return caffeineCacheManager;
    }

    @Bean(name={"questionnaireCacheManager"})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public RedisCacheManager questionnaireCacheManager(@NonNull RedisConnectionFactory redisConnectionFactory) {
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(redisCacheConfiguration).initialCacheNames(Set.of("questionnaireCache")).disableCreateOnMissingCache().build();
    }

    @Bean(name={"sessionAccessCacheManager"})
    public CacheManager sessionAccessCacheManager() {
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager(new String[]{"sessionAccessCacheManager"});
        caffeineCacheManager.setCaffeine(Caffeine.newBuilder().maximumSize(100L));
        caffeineCacheManager.setAllowNullValues(false);
        return caffeineCacheManager;
    }

    @Bean
    @Primary
    public CacheManager cacheManager(@Qualifier(value="sessionCacheManager") Optional<CacheManager> localSessionCacheManager, @Qualifier(value="questionnaireCacheManager") Optional<CacheManager> questionnaireCache, @Qualifier(value="formCacheManager") Optional<CacheManager> formCacheManager, @Qualifier(value="dialobProgramsCacheManager") Optional<CacheManager> programCacheManager, @Qualifier(value="sessionAccessCacheManager") Optional<CacheManager> sessionAccessCacheManager) {
        CompositeCacheManager compositeCacheManager = new CompositeCacheManager();
        ArrayList cacheManagers = new ArrayList();
        localSessionCacheManager.ifPresent(cacheManagers::add);
        questionnaireCache.ifPresent(cacheManagers::add);
        formCacheManager.ifPresent(cacheManagers::add);
        programCacheManager.ifPresent(cacheManagers::add);
        sessionAccessCacheManager.ifPresent(cacheManagers::add);
        compositeCacheManager.setCacheManagers(cacheManagers);
        compositeCacheManager.setFallbackToNoOpCache(true);
        return compositeCacheManager;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"dialob.session.cache.type"}, matchIfMissing=true, havingValue="LOCAL")
    public static class LocalQuestionnaireDialobSessionCacheConfiguration {
        private final QuestionnaireSessionCache questionnaireSessionCache = new LocalQuestionnaireSessionCache("sessionCache");

        @Bean(name={"sessionCacheManager"})
        public CacheManager sessionCacheManager() {
            SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
            simpleCacheManager.setCaches(Collections.singletonList(this.questionnaireSessionCache));
            simpleCacheManager.afterPropertiesSet();
            return simpleCacheManager;
        }

        @Bean
        public ScheduledSessionEvictionPolicy scheduledSessionEvictionPolicy(Optional<QuestionnaireSessionSaveService> sessionService, Optional<CacheManager> cacheManager, DialobSettings dialobSettings) {
            return new ScheduledSessionEvictionPolicy(this.questionnaireSessionCache, this.sessionEvictionCallback(sessionService, dialobSettings), cacheManager, dialobSettings.getSession().getCache().getTimeToLive());
        }

        Function<QuestionnaireSession, QuestionnaireSession> sessionEvictionCallback(Optional<QuestionnaireSessionSaveService> sessionService, DialobSettings dialobSettings) {
            if (dialobSettings.getSession().getCache().isPersistOnEviction()) {
                return sessionService.map(ss -> arg_0 -> ((QuestionnaireSessionSaveService)ss).save(arg_0)).orElseGet(Function::identity);
            }
            return Function.identity();
        }
    }
}

