/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.implementation.support.internal.shadow;

import io.determann.shadow.api.C;
import io.determann.shadow.api.query.ImplementationDefined;
import io.determann.shadow.api.query.Operations;
import io.determann.shadow.api.query.Provider;
import io.determann.shadow.api.query.Response;
import io.determann.shadow.api.query.operation.InstanceOperation;
import io.determann.shadow.api.query.operation.InstanceOperation0;
import io.determann.shadow.api.query.operation.InstanceOperation1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public class SupportSupport {
    @SafeVarargs
    public static <TYPE extends ImplementationDefined> boolean equals(TYPE type, Class<TYPE> tClass, Object other, InstanceOperation0<? super TYPE, ?> ... operations) {
        if (type == other) {
            return true;
        }
        if (!tClass.isInstance(other)) {
            return false;
        }
        ImplementationDefined otherTYPE = (ImplementationDefined)other;
        return Arrays.stream(operations).allMatch(tOperation -> {
            Response first = Provider.request((ImplementationDefined)type, (InstanceOperation0)tOperation);
            Response second = Provider.request((ImplementationDefined)otherTYPE, (InstanceOperation0)tOperation);
            return first instanceof Response.Unsupported || second instanceof Response.Unsupported || Objects.equals(first, second);
        });
    }

    @SafeVarargs
    public static <TYPE extends ImplementationDefined> int hashCode(TYPE type, InstanceOperation0<? super TYPE, ?> ... operations) {
        return Objects.hash(Arrays.stream(operations).map(typeOperation -> Provider.request((ImplementationDefined)type, (InstanceOperation0)typeOperation)).toArray());
    }

    @SafeVarargs
    public static <TYPE extends ImplementationDefined> String toString(TYPE type, Class<TYPE> typeClass, InstanceOperation0<? super TYPE, ?> ... operations) {
        String simpleName = typeClass.getSimpleName();
        int index = simpleName.indexOf(95);
        if (index != -1 && index + 1 < simpleName.length()) {
            simpleName = simpleName.substring(index + 1);
        }
        return simpleName + " {" + Arrays.stream(operations).map(operation -> SupportSupport.getOperationName(operation) + "=" + Provider.requestOrEmpty((ImplementationDefined)type, (InstanceOperation0)operation).map(SupportSupport::sortCollection).map(Object::toString).orElse("")).collect(Collectors.joining(", ")) + "}";
    }

    private static Object sortCollection(Object o) {
        Collection collection;
        if (!(o instanceof Collection) || (collection = (Collection)o).isEmpty() || !(collection.iterator().next() instanceof Comparable)) {
            return o;
        }
        ArrayList objects = new ArrayList(collection);
        Collections.sort(objects);
        return objects;
    }

    private static String getOperationName(InstanceOperation<?, ?> instanceOperation) {
        String name = instanceOperation.getName();
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    @SafeVarargs
    public static <TYPE extends C.Type> boolean representsSameType(TYPE type, Class<TYPE> tClass, Object other, InstanceOperation0<? super TYPE, ?> ... operations) {
        if (type == other) {
            return true;
        }
        if (!tClass.isInstance(other)) {
            return false;
        }
        C.Type otherTYPE = (C.Type)other;
        return Arrays.stream(operations).allMatch(tOperation -> {
            Response first = Provider.request((ImplementationDefined)type, (InstanceOperation0)tOperation);
            Response second = Provider.request((ImplementationDefined)otherTYPE, (InstanceOperation0)tOperation);
            if (first instanceof Response.Unsupported) return true;
            if (second instanceof Response.Unsupported) return true;
            if (first instanceof Response.Result) {
                Object firstValue;
                Response.Result $b$0 = (Response.Result)first;
                try {
                    Object patt1$temp;
                    firstValue = patt1$temp = $b$0.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (firstValue instanceof C.Type) {
                    Response.Result $b$2;
                    Object patt3$temp;
                    Object secondValue;
                    C.Type firstType = (C.Type)firstValue;
                    if (second instanceof Response.Result && (secondValue = (patt3$temp = ($b$2 = (Response.Result)second).value())) instanceof C.Type) {
                        C.Type secondType = (C.Type)secondValue;
                        if (Provider.requestOrEmpty((ImplementationDefined)firstType, (InstanceOperation1)Operations.TYPE_REPRESENTS_SAME_TYPE, (Object)secondType).orElse(false) != false) return true;
                    }
                }
            }
            if (Objects.equals(first, second)) return true;
            return false;
        });
    }
}

