/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.implementation.support.internal.property;

import io.determann.shadow.api.C;
import io.determann.shadow.api.query.Implementation;
import io.determann.shadow.implementation.support.api.shadow.structure.PropertySupport;
import io.determann.shadow.implementation.support.internal.SupportProvider;
import java.util.Optional;

public class PropertyImpl
implements C.Property {
    private final String name;
    private final C.VariableType type;
    private final C.Field field;
    private final C.Method getter;
    private final C.Method setter;

    PropertyImpl(String name, C.VariableType type, C.Field field, C.Method getter, C.Method setter) {
        this.name = name;
        this.type = type;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    public C.VariableType getType() {
        return this.type;
    }

    public Optional<C.Field> getField() {
        return Optional.ofNullable(this.field);
    }

    public C.Method getGetter() {
        return this.getter;
    }

    public Optional<C.Method> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    public boolean isMutable() {
        return this.getSetter().isPresent();
    }

    public int hashCode() {
        return PropertySupport.hashCode(this);
    }

    public boolean equals(Object other) {
        return PropertySupport.equals(this, other);
    }

    public String toString() {
        return PropertySupport.toString(this);
    }

    public Implementation getImplementation() {
        return SupportProvider.IMPLEMENTATION;
    }
}

