/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.implementation.support.internal.property;

import io.determann.shadow.api.C;
import io.determann.shadow.api.Modifier;
import io.determann.shadow.api.query.ImplementationDefined;
import io.determann.shadow.api.query.Operations;
import io.determann.shadow.api.query.Provider;
import io.determann.shadow.api.query.operation.InstanceOperation0;
import io.determann.shadow.api.query.operation.InstanceOperation1;
import io.determann.shadow.implementation.support.internal.property.PropertyImpl;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyFactory {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    private PropertyFactory() {
    }

    public static List<C.Property> of(C.Declared declared) {
        Map nameField = ((List)Provider.requestOrThrow((ImplementationDefined)declared, (InstanceOperation0)Operations.DECLARED_GET_FIELDS)).stream().filter(field -> (Boolean)Provider.requestOrThrow((ImplementationDefined)field, (InstanceOperation1)Operations.MODIFIABLE_HAS_MODIFIER, (Object)Modifier.STATIC) == false).collect(Collectors.toMap(field -> (String)Provider.requestOrThrow((ImplementationDefined)field, (InstanceOperation0)Operations.NAMEABLE_GET_NAME), Function.identity()));
        AtomicInteger position = new AtomicInteger();
        Map<String, Map<AccessorType, List<Accessor>>> nameTypeAccessors = PropertyFactory.getMethods(declared).stream().filter(method -> (Boolean)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation1)Operations.MODIFIABLE_HAS_MODIFIER, (Object)Modifier.STATIC) == false).map(method1 -> PropertyFactory.toAccessor(method1, position.getAndIncrement())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(Accessor::name, Collectors.groupingBy(Accessor::type)));
        return nameTypeAccessors.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey((Object)AccessorType.GETTER)).map(entry -> {
            Accessor getter = PropertyFactory.findGetter((Map)entry.getValue());
            String name = (String)entry.getKey();
            C.VariableType type = (C.VariableType)Provider.requestOrThrow((ImplementationDefined)getter.method(), (InstanceOperation0)Operations.METHOD_GET_RETURN_TYPE);
            C.Method setter = PropertyFactory.findSetter((Map)entry.getValue(), (C.Type)type).orElse(null);
            C.Field field = PropertyFactory.findField(nameField, (C.Type)type, name).orElse(null);
            PropertyImpl template = new PropertyImpl(name, type, field, getter.method(), setter);
            return new AbstractMap.SimpleEntry<Integer, PropertyImpl>(getter.position(), template);
        }).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(C.Property.class::cast).toList();
    }

    private static List<? extends C.Method> getMethods(C.Declared declared) {
        if (!(declared instanceof C.Class)) {
            return (List)Provider.requestOrThrow((ImplementationDefined)declared, (InstanceOperation0)Operations.DECLARED_GET_METHODS);
        }
        C.Class aClass = (C.Class)declared;
        List superClasses = Stream.iterate(aClass, Objects::nonNull, aClass1 -> (C.Class)Provider.requestOrThrow((ImplementationDefined)aClass1, (InstanceOperation0)Operations.CLASS_GET_SUPER_CLASS)).collect(Collectors.toList());
        Collections.reverse(superClasses);
        List methods = superClasses.stream().flatMap(aClass1 -> ((List)Provider.requestOrThrow((ImplementationDefined)aClass1, (InstanceOperation0)Operations.DECLARED_GET_METHODS)).stream()).toList();
        return methods.stream().filter(method -> methods.stream().noneMatch(method1 -> (Boolean)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation1)Operations.METHOD_OVERWRITTEN_BY, (Object)method1))).toList();
    }

    private static Optional<C.Field> findField(Map<String, C.Field> nameField, C.Type type, String name) {
        C.Field field = nameField.get(name);
        if (field == null || !((Boolean)Provider.requestOrThrow((ImplementationDefined)((C.VariableType)Provider.requestOrThrow((ImplementationDefined)field, (InstanceOperation0)Operations.VARIABLE_GET_TYPE)), (InstanceOperation1)Operations.TYPE_REPRESENTS_SAME_TYPE, (Object)type)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(field);
    }

    private static Optional<C.Method> findSetter(Map<AccessorType, List<Accessor>> typeAccessors, C.Type type) {
        List<Accessor> setters = typeAccessors.get((Object)AccessorType.SETTER);
        if (setters == null || setters.size() != 1 || !((Boolean)Provider.requestOrThrow((ImplementationDefined)((C.VariableType)Provider.requestOrThrow((ImplementationDefined)((ImplementationDefined)((List)Provider.requestOrThrow((ImplementationDefined)setters.get(0).method(), (InstanceOperation0)Operations.EXECUTABLE_GET_PARAMETERS)).get(0)), (InstanceOperation0)Operations.VARIABLE_GET_TYPE)), (InstanceOperation1)Operations.TYPE_REPRESENTS_SAME_TYPE, (Object)type)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(setters.get(0).method());
    }

    private static Accessor findGetter(Map<AccessorType, List<Accessor>> typeAccessors) {
        List<Accessor> getters = typeAccessors.get((Object)AccessorType.GETTER);
        if (getters == null || getters.size() > 2) {
            throw new IllegalStateException();
        }
        if (getters.size() == 1) {
            return getters.get(0);
        }
        if (getters.size() == 2) {
            for (Accessor accessor : getters) {
                if (!accessor.prefix().equals(IS_PREFIX)) continue;
                return accessor;
            }
        }
        throw new IllegalStateException();
    }

    private static Optional<Accessor> toAccessor(C.Method method, int position) {
        boolean couldBeSetter;
        String name = (String)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation0)Operations.NAMEABLE_GET_NAME);
        List parameters = (List)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation0)Operations.EXECUTABLE_GET_PARAMETERS);
        C.Type returnType = (C.Type)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation0)Operations.METHOD_GET_RETURN_TYPE);
        if (!(returnType instanceof C.Void)) {
            C.Declared declared;
            boolean hasIsPrefix;
            boolean hasGetPrefix = name.startsWith(GET_PREFIX) && name.length() > 3;
            boolean bl = hasIsPrefix = (returnType instanceof C.boolean_ || returnType instanceof C.Declared && "java.lang.Boolean".equals(Provider.requestOrThrow((ImplementationDefined)(declared = (C.Declared)returnType), (InstanceOperation0)Operations.QUALIFIED_NAMEABLE_GET_QUALIFIED_NAME))) && name.startsWith(IS_PREFIX) && name.length() > 2;
            if (parameters.isEmpty()) {
                if (hasGetPrefix) {
                    return Optional.of(new Accessor(method, AccessorType.GETTER, GET_PREFIX, PropertyFactory.toPropertyName(method, GET_PREFIX), position));
                }
                if (hasIsPrefix) {
                    return Optional.of(new Accessor(method, AccessorType.GETTER, IS_PREFIX, PropertyFactory.toPropertyName(method, IS_PREFIX), position));
                }
            }
            return Optional.empty();
        }
        boolean bl = couldBeSetter = name.startsWith(SET_PREFIX) && name.length() > 3;
        if (couldBeSetter && parameters.size() == 1) {
            return Optional.of(new Accessor(method, AccessorType.SETTER, SET_PREFIX, PropertyFactory.toPropertyName(method, SET_PREFIX), position));
        }
        return Optional.empty();
    }

    private static String toPropertyName(C.Method method, String prefix) {
        String name = ((String)Provider.requestOrThrow((ImplementationDefined)method, (InstanceOperation0)Operations.NAMEABLE_GET_NAME)).substring(prefix.length());
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static enum AccessorType {
        GETTER,
        SETTER;

    }

    private record Accessor(C.Method method, AccessorType type, String prefix, String name, int position) {
    }
}

