/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.implementation.support.api.provider;

import io.determann.shadow.api.query.Implementation;
import io.determann.shadow.api.query.Response;
import io.determann.shadow.api.query.operation.InstanceOperation0;
import io.determann.shadow.api.query.operation.InstanceOperation1;
import io.determann.shadow.api.query.operation.InstanceOperation2;
import io.determann.shadow.api.query.operation.Operation;
import io.determann.shadow.api.query.operation.StaticOperation0;
import io.determann.shadow.api.query.operation.StaticOperation1;
import io.determann.shadow.api.query.operation.StaticOperation2;
import io.determann.shadow.api.query.operation.TriFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MappingBuilder {
    private final Map<Operation<?>, BiFunction<?, Object[], Response<?>>> map = new HashMap();

    public <RESULT> MappingBuilder with(StaticOperation0<RESULT> operation, Function<Implementation, ? extends RESULT> supplier) {
        return this.add((Operation<?>)operation, (o, objects) -> supplier.apply((Implementation)o));
    }

    public <RESULT> MappingBuilder withOptional(StaticOperation0<RESULT> operation, Function<Implementation, Optional<? extends RESULT>> supplier) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)supplier.apply((Implementation)o));
    }

    public <FROM, RESULT> MappingBuilder withCast(StaticOperation0<FROM> operation, Function<Implementation, Response<RESULT>> supplier) {
        return this.addCast((Operation<?>)operation, (o, objects) -> (Response)supplier.apply((Implementation)o));
    }

    public <PARAM_1, RESULT> MappingBuilder with(StaticOperation1<PARAM_1, RESULT> operation, BiFunction<Implementation, PARAM_1, ? extends RESULT> supplier) {
        return this.add((Operation<?>)operation, (o, objects) -> supplier.apply((Implementation)o, objects[0]));
    }

    public <PARAM_1, RESULT> MappingBuilder withOptional(StaticOperation1<PARAM_1, RESULT> operation, BiFunction<Implementation, PARAM_1, Optional<? extends RESULT>> supplier) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)supplier.apply((Implementation)o, objects[0]));
    }

    public <PARAM_1, FROM, RESULT> MappingBuilder withCast(StaticOperation1<PARAM_1, FROM> operation, BiFunction<Implementation, PARAM_1, Response<RESULT>> supplier) {
        return this.addCast((Operation<?>)operation, (o, objects) -> (Response)supplier.apply((Implementation)o, objects[0]));
    }

    public <PARAM_1, PARAM_2, RESULT> MappingBuilder with(StaticOperation2<PARAM_1, PARAM_2, RESULT> operation, TriFunction<Implementation, PARAM_1, PARAM_2, ? extends RESULT> supplier) {
        return this.add((Operation<?>)operation, (o, objects) -> supplier.apply((Object)((Implementation)o), objects[0], objects[1]));
    }

    public <PARAM_1, PARAM_2, RESULT> MappingBuilder withOptional(StaticOperation2<PARAM_1, PARAM_2, RESULT> operation, TriFunction<Implementation, PARAM_1, PARAM_2, Optional<? extends RESULT>> supplier) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)supplier.apply((Object)((Implementation)o), objects[0], objects[1]));
    }

    public <PARAM_1, PARAM_2, FROM, RESULT> MappingBuilder withCast(StaticOperation2<PARAM_1, PARAM_2, FROM> operation, TriFunction<Implementation, PARAM_1, PARAM_2, Response<RESULT>> supplier) {
        return this.addCast((Operation<?>)operation, (o, objects) -> (Response)supplier.apply((Object)((Implementation)o), objects[0], objects[1]));
    }

    public <TYPE, RESULT> MappingBuilder with(InstanceOperation0<TYPE, RESULT> operation, Function<TYPE, ? extends RESULT> mapping) {
        return this.add((Operation<?>)operation, (o, objects) -> mapping.apply(o));
    }

    public <TYPE, RESULT> MappingBuilder withOptional(InstanceOperation0<TYPE, RESULT> operation, Function<TYPE, Optional<? extends RESULT>> mapping) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)mapping.apply(o));
    }

    public <TYPE, FROM, RESULT> MappingBuilder withCast(InstanceOperation0<TYPE, FROM> operation, Function<TYPE, Response<RESULT>> mapping) {
        return this.addCast((Operation<?>)operation, (o, objects) -> (Response)mapping.apply(o));
    }

    public <TYPE, PARAM_1, RESULT> MappingBuilder with(InstanceOperation1<TYPE, PARAM_1, RESULT> operation, BiFunction<TYPE, PARAM_1, RESULT> mapping) {
        return this.add((Operation<?>)operation, (o, objects) -> mapping.apply(o, objects[0]));
    }

    public <TYPE, PARAM_1, RESULT> MappingBuilder withOptional(InstanceOperation1<TYPE, PARAM_1, RESULT> operation, BiFunction<TYPE, PARAM_1, Optional<RESULT>> mapping) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)mapping.apply(o, objects[0]));
    }

    public <TYPE, PARAM_1, FROM, RESULT> MappingBuilder withCast(InstanceOperation1<FROM, PARAM_1, RESULT> operation, BiFunction<TYPE, PARAM_1, Response<RESULT>> mapping) {
        return this.addCast((Operation<?>)operation, (o, objects) -> (Response)mapping.apply(o, objects[0]));
    }

    public <TYPE, PARAM_1, PARAM_2, RESULT> MappingBuilder with(InstanceOperation2<TYPE, PARAM_1, PARAM_2, RESULT> operation, TriFunction<TYPE, PARAM_1, PARAM_2, RESULT> mapping) {
        return this.add((Operation<?>)operation, (o, objects) -> mapping.apply(o, objects[0], objects[1]));
    }

    public <TYPE, PARAM_1, PARAM_2, RESULT> MappingBuilder withOptional(InstanceOperation2<TYPE, PARAM_1, PARAM_2, RESULT> operation, TriFunction<TYPE, PARAM_1, PARAM_2, Optional<RESULT>> mapping) {
        return this.addOptional((Operation<?>)operation, (o, objects) -> (Optional)mapping.apply(o, objects[0], objects[1]));
    }

    private MappingBuilder add(Operation<?> operation, BiFunction<Object, Object[], ?> function) {
        this.map.put(operation, (o, params) -> new Response.Result(function.apply(o, (Object[])params)));
        return this;
    }

    private MappingBuilder addOptional(Operation<?> operation, BiFunction<Object, Object[], Optional<?>> function) {
        this.map.put(operation, (o, params) -> ((Optional)function.apply(o, (Object[])params)).map(Response.Result::new).orElseGet(Response.Empty::new));
        return this;
    }

    private MappingBuilder addCast(Operation<?> operation, BiFunction<Object, Object[], Response<?>> function) {
        this.map.put(operation, function);
        return this;
    }

    Map<Operation<?>, BiFunction<?, Object[], Response<?>>> getMap() {
        return this.map;
    }
}

