/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.nodejs;

import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.BuildInfoBuilder;
import io.dekorate.project.BuildInfoReader;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Git;
import io.dekorate.utils.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class NodeInfoReader
implements BuildInfoReader {
    private final Logger LOGGER = LoggerFactory.getLogger();
    private static final String NPM = "npm";
    private static final String PACKAGE_JSON = "package.json";
    private static final String SRC = "src";
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final String QUOTE = "'";
    private static final String EQUALS = "=";
    private static final String COLON = ":";
    private static final String DASH = "-";
    private static final String DOT = ".";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String BIN = "bin";
    private static final String MAIN = "main";
    public static final String NEW_LINE = "[\\n\\r]+";
    private static final String INDEX_JS = "index.js";

    public int order() {
        return 500;
    }

    public boolean isApplicable(Path root) {
        return root.resolve(PACKAGE_JSON).toFile().exists();
    }

    public BuildInfo getInfo(Path root) {
        Path packageJson = root.resolve(PACKAGE_JSON);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(NodeInfoReader.readPackageJson(packageJson));
        String name = properties.getOrDefault(NAME, properties.getOrDefault(NAME, root.getFileName().toString()));
        String version = (String)properties.get(VERSION);
        String main = properties.getOrDefault(MAIN, INDEX_JS);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (Strings.isNotNullOrEmpty((String)version)) {
            sb.append(DASH).append(version);
        }
        if (version == null) {
            this.LOGGER.warning("Could not detect project version. Using 'latest'.");
            version = "latest";
        }
        return ((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)((BuildInfoBuilder)new BuildInfoBuilder().withName(name)).withVersion(version)).withPackaging("js")).withBuildTool(NPM)).withBuildToolVersion(NodeInfoReader.getVersion(root))).withOutputFile(root.resolve(main))).withClassOutputDir(null)).withResourceDir(null)).build();
    }

    protected static Map<String, String> readPackageJson(Path path) {
        AtomicInteger quotes = new AtomicInteger(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Files.lines(path).map(l -> l.replaceAll("[ ]*", "")).forEach(l -> {
                if (l.contains(OPEN_BRACKET)) {
                    quotes.incrementAndGet();
                }
                if (l.contains(CLOSE_BRACKET)) {
                    quotes.decrementAndGet();
                }
                if (quotes.get() == 1 && l.contains(NAME)) {
                    String name = NodeInfoReader.readValue(l);
                    properties.put(NAME, name);
                }
                if (quotes.get() == 1 && l.contains(VERSION)) {
                    String version = NodeInfoReader.readValue(l);
                    properties.put(VERSION, version);
                }
                if (quotes.get() == 1 && l.contains(MAIN)) {
                    String main = NodeInfoReader.readValue(l);
                    properties.put(MAIN, main);
                }
            });
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
        return properties;
    }

    private static String readValue(String l) {
        return l.substring(l.lastIndexOf(COLON) + 1).replaceAll(QUOTE, "").replaceAll(Pattern.quote("\""), "").replaceAll(",$", "").trim();
    }

    public static String getVersion(Path modulePath) {
        Path packageJson = Git.getRoot((Path)modulePath).orElse(modulePath).resolve(PACKAGE_JSON);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Exec.ProjectExec exec = Exec.inPath((Path)modulePath).redirectingOutput((OutputStream)out);
        boolean success = exec.commands(new String[]{NPM, VERSION});
        return NodeInfoReader.getVersionFromOutput(new String(out.toByteArray()));
    }

    protected static String getVersionFromOutput(String output) {
        if (Strings.isNullOrEmpty((String)output)) {
            throw new IllegalArgumentException("nodejs version output should not be empty!");
        }
        return Arrays.stream(output.split(NEW_LINE)).filter(l -> l.contains(NPM)).map(NodeInfoReader::readValue).findFirst().orElseThrow(() -> new IllegalStateException("Unknown nodejs version output format. Expected at least one line!"));
    }
}

