/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.web.shared.data;

import io.deephaven.web.shared.data.Range;
import io.deephaven.web.shared.data.ShiftedRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.LongStream;

public class RangeSet {
    private List<Range> sortedRanges = new ArrayList<Range>();
    private int firstWrongCacheEntry = 0;
    private long[] cardinality = new long[0];

    public static RangeSet empty() {
        return new RangeSet();
    }

    public static RangeSet ofRange(long first, long last) {
        RangeSet rangeSet = new RangeSet();
        rangeSet.addRange(new Range(first, last));
        return rangeSet;
    }

    public static RangeSet ofItems(long ... items) {
        RangeSet rangeSet = new RangeSet();
        for (int i = 0; i < items.length; ++i) {
            long item = items[i];
            rangeSet.addRange(new Range(item, item));
        }
        return rangeSet;
    }

    public static RangeSet fromSortedRanges(List<Range> sortedRanges) {
        RangeSet.assertOrderedAndNonOverlapping(sortedRanges.toArray(new Range[0]));
        RangeSet rangeSet = new RangeSet();
        rangeSet.sortedRanges = sortedRanges;
        return rangeSet;
    }

    public static RangeSet fromSortedRanges(Range[] sortedRanges) {
        RangeSet.assertOrderedAndNonOverlapping(sortedRanges);
        RangeSet rangeSet = new RangeSet();
        rangeSet.sortedRanges.addAll(Arrays.asList(sortedRanges));
        return rangeSet;
    }

    private static void assertOrderedAndNonOverlapping(Range[] sortedRanges) {
        long lastSeen = -1L;
        for (int i = 0; i < sortedRanges.length; ++i) {
            assert (lastSeen < sortedRanges[i].getFirst() || lastSeen == -1L) : String.valueOf(sortedRanges[i - 1]) + " came before " + String.valueOf(sortedRanges[i]) + " (index=" + i + ")";
            lastSeen = sortedRanges[i].getLast();
        }
    }

    public void addRangeSet(RangeSet rangeSet) {
        if (this.isEmpty() && !rangeSet.isEmpty()) {
            this.sortedRanges = new ArrayList<Range>(rangeSet.sortedRanges);
            this.poisonCache(0);
        } else if (!rangeSet.isEmpty()) {
            RangeAccumulator newRanges = new RangeAccumulator();
            Iterator<Range> rangeIterator = this.sortedRanges.iterator();
            Iterator<Range> addIterator = rangeSet.sortedRanges.iterator();
            Range toCheck = rangeIterator.next();
            Range toAdd = addIterator.next();
            while (true) {
                if (toCheck.getLast() < toAdd.getFirst()) {
                    newRanges.appendRange(toCheck);
                    if (!rangeIterator.hasNext()) {
                        toCheck = null;
                        break;
                    }
                    toCheck = rangeIterator.next();
                    continue;
                }
                if (toCheck.getFirst() > toAdd.getLast()) {
                    newRanges.appendRange(toAdd);
                    if (!addIterator.hasNext()) {
                        toAdd = null;
                        break;
                    }
                    toAdd = addIterator.next();
                    continue;
                }
                Range overlap = toCheck.overlap(toAdd);
                assert (overlap != null);
                newRanges.appendRange(overlap);
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                if (!addIterator.hasNext()) {
                    toAdd = null;
                    break;
                }
                toAdd = addIterator.next();
            }
            if (toCheck != null) {
                assert (toAdd == null);
                newRanges.appendRange(toCheck);
                while (rangeIterator.hasNext()) {
                    newRanges.appendRange(rangeIterator.next());
                }
            } else {
                assert (toAdd != null);
                newRanges.appendRange(toAdd);
                while (addIterator.hasNext()) {
                    newRanges.appendRange(addIterator.next());
                }
            }
            this.sortedRanges = newRanges.build();
            this.poisonCache(0);
        }
    }

    public void addRange(Range range) {
        this.addRangeSet(RangeSet.fromSortedRanges(Collections.singletonList(range)));
    }

    public void removeRangeSet(RangeSet rangeSet) {
        if (this.isEmpty() || rangeSet.isEmpty()) {
            return;
        }
        RangeAccumulator newRanges = new RangeAccumulator();
        RangeIterator rangeIterator = new RangeIterator(this.sortedRanges);
        Iterator<Range> removeIterator = rangeSet.sortedRanges.iterator();
        Range toCheck = rangeIterator.next();
        Range toRemove = removeIterator.next();
        while (true) {
            if (toCheck.getLast() < toRemove.getFirst()) {
                newRanges.appendRange(toCheck);
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            if (toCheck.getFirst() > toRemove.getLast()) {
                if (!removeIterator.hasNext()) break;
                toRemove = removeIterator.next();
                continue;
            }
            Range[] remaining = toCheck.minus(toRemove);
            if (remaining.length == 0) {
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            if (remaining.length == 1) {
                Range remainingRange = remaining[0];
                if (remainingRange.compareTo(toCheck) > 0) {
                    rangeIterator.advanceInCurrentRangeToKey(remainingRange.getFirst());
                    toCheck = rangeIterator.next();
                    if (!removeIterator.hasNext()) break;
                    toRemove = removeIterator.next();
                    continue;
                }
                newRanges.appendRange(remainingRange);
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            assert (remaining.length == 2);
            newRanges.appendRange(remaining[0]);
            rangeIterator.advanceInCurrentRangeToKey(remaining[1].getFirst());
            toCheck = rangeIterator.next();
            if (!removeIterator.hasNext()) break;
            toRemove = removeIterator.next();
        }
        if (toCheck != null) {
            newRanges.appendRange(toCheck);
            while (rangeIterator.hasNext()) {
                newRanges.appendRange(rangeIterator.next());
            }
        }
        this.sortedRanges = newRanges.build();
        this.poisonCache(0);
    }

    public void removeRange(Range range) {
        this.removeRangeSet(RangeSet.fromSortedRanges(Collections.singletonList(range)));
    }

    public void clear() {
        this.sortedRanges.clear();
        this.poisonCache(0);
    }

    public void applyShifts(ShiftedRange[] shiftedRanges) {
        if (shiftedRanges.length == 0 || this.isEmpty()) {
            return;
        }
        RangeAccumulator newRanges = new RangeAccumulator();
        RangeIterator rangeIterator = new RangeIterator(this.sortedRanges);
        Iterator<ShiftedRange> shiftIterator = Arrays.asList(shiftedRanges).iterator();
        Range toCheck = rangeIterator.next();
        ShiftedRange shiftedRange = shiftIterator.next();
        while (true) {
            if (toCheck.getLast() < shiftedRange.getRange().getFirst()) {
                newRanges.appendRange(toCheck);
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            if (toCheck.getFirst() > shiftedRange.getRange().getLast()) {
                if (!shiftIterator.hasNext()) break;
                shiftedRange = shiftIterator.next();
                continue;
            }
            Range[] remaining = toCheck.minus(shiftedRange.getRange());
            if (remaining.length == 0) {
                newRanges.appendRange(toCheck.shift(shiftedRange.getDelta()));
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            if (remaining.length == 1) {
                Range remainingRange = remaining[0];
                Range[] complimentArr = toCheck.minus(remainingRange);
                assert (complimentArr.length == 1);
                Range compliment = complimentArr[0];
                if (remainingRange.compareTo(toCheck) > 0) {
                    newRanges.appendRange(compliment.shift(shiftedRange.getDelta()));
                    rangeIterator.advanceInCurrentRangeToKey(remainingRange.getFirst());
                    toCheck = rangeIterator.next();
                    if (!shiftIterator.hasNext()) break;
                    shiftedRange = shiftIterator.next();
                    continue;
                }
                newRanges.appendRange(remainingRange);
                newRanges.appendRange(compliment.shift(shiftedRange.getDelta()));
                if (!rangeIterator.hasNext()) {
                    toCheck = null;
                    break;
                }
                toCheck = rangeIterator.next();
                continue;
            }
            assert (remaining.length == 2);
            newRanges.appendRange(remaining[0]);
            newRanges.appendRange(shiftedRange.getResultRange());
            rangeIterator.advanceInCurrentRangeToKey(remaining[1].getFirst());
            toCheck = rangeIterator.next();
            if (!shiftIterator.hasNext()) break;
            shiftedRange = shiftIterator.next();
        }
        if (toCheck != null) {
            newRanges.appendRange(toCheck);
            while (rangeIterator.hasNext()) {
                newRanges.appendRange(rangeIterator.next());
            }
        }
        this.sortedRanges = newRanges.build();
        this.poisonCache(0);
    }

    public Iterator<Range> rangeIterator() {
        return this.sortedRanges.iterator();
    }

    public Iterator<Range> reverseRangeIterator() {
        return new Iterator<Range>(){
            int i;
            {
                this.i = RangeSet.this.sortedRanges.size();
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Range next() {
                return RangeSet.this.sortedRanges.get(--this.i);
            }
        };
    }

    public PrimitiveIterator.OfLong indexIterator() {
        if (this.isEmpty()) {
            return LongStream.empty().iterator();
        }
        return new PrimitiveIterator.OfLong(){
            private int rangeIndex = 0;
            private Range current;
            private long offsetInRange;
            {
                this.current = RangeSet.this.sortedRanges.get(0);
                this.offsetInRange = 0L;
            }

            @Override
            public long nextLong() {
                long value = this.current.getFirst() + this.offsetInRange;
                if (++this.offsetInRange >= this.current.size()) {
                    ++this.rangeIndex;
                    this.offsetInRange = 0L;
                    this.current = this.rangeIndex < RangeSet.this.rangeCount() ? RangeSet.this.sortedRanges.get(this.rangeIndex) : null;
                }
                return value;
            }

            @Override
            public boolean hasNext() {
                return this.rangeIndex < RangeSet.this.rangeCount();
            }
        };
    }

    public int rangeCount() {
        return this.sortedRanges.size();
    }

    public boolean isFlat() {
        return this.sortedRanges.isEmpty() || this.sortedRanges.size() == 1 && this.getFirstRow() == 0L;
    }

    public long size() {
        if (this.rangeCount() == 0) {
            return 0L;
        }
        this.ensureCardinalityCache();
        return this.cardinality[this.sortedRanges.size() - 1];
    }

    public boolean isEmpty() {
        return this.rangeCount() == 0;
    }

    public boolean contains(long value) {
        return this.includesAllOf(RangeSet.ofItems(value));
    }

    public boolean includesAllOf(RangeSet other) {
        Iterator<Range> seenIterator = this.rangeIterator();
        Iterator<Range> mustMatchIterator = other.rangeIterator();
        if (!mustMatchIterator.hasNext()) {
            return true;
        }
        if (!seenIterator.hasNext()) {
            return false;
        }
        block0: while (mustMatchIterator.hasNext()) {
            Range match = mustMatchIterator.next();
            while (seenIterator.hasNext()) {
                Range current = seenIterator.next();
                if (match.getFirst() < current.getFirst()) {
                    return false;
                }
                if (match.getFirst() > current.getLast()) continue;
                if (match.getLast() <= current.getLast()) continue block0;
                return false;
            }
        }
        return true;
    }

    public boolean includesAnyOf(Range range) {
        if (this.isEmpty()) {
            return false;
        }
        int index = Collections.binarySearch(this.sortedRanges, range);
        if (index >= 0) {
            return true;
        }
        index = Math.max(0, -index - 2);
        Range target = this.sortedRanges.get(index);
        if (range.getFirst() <= target.getLast() && range.getLast() >= target.getFirst()) {
            return true;
        }
        if (++index >= this.rangeCount()) {
            return false;
        }
        target = this.sortedRanges.get(index);
        return range.getFirst() <= target.getLast() && range.getLast() >= target.getFirst();
    }

    public long find(long key) {
        long cnt = 0L;
        Iterator<Range> seenIterator = this.rangeIterator();
        while (seenIterator.hasNext()) {
            Range current = seenIterator.next();
            if (key < current.getFirst()) {
                return -cnt - 1L;
            }
            if (key > current.getLast()) {
                cnt += current.size();
                continue;
            }
            if (key > current.getLast()) continue;
            return cnt + key - current.getFirst();
        }
        return -cnt - 1L;
    }

    public String toString() {
        return "RangeSet{sortedRanges=" + String.valueOf(this.sortedRanges) + "}";
    }

    public long getFirstRow() {
        return this.sortedRanges.get(0).getFirst();
    }

    public long getLastRow() {
        return this.sortedRanges.get(this.rangeCount() - 1).getLast();
    }

    public RangeSet copy() {
        RangeSet copy = new RangeSet();
        copy.sortedRanges = new ArrayList<Range>(this.sortedRanges);
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeSet rangeSet = (RangeSet)o;
        return this.sortedRanges.equals(rangeSet.sortedRanges);
    }

    public int hashCode() {
        return this.sortedRanges.hashCode();
    }

    private void poisonCache(int rangeIndex) {
        this.firstWrongCacheEntry = Math.min(rangeIndex, this.firstWrongCacheEntry);
    }

    private void ensureCardinalityCache() {
        if (this.firstWrongCacheEntry == this.rangeCount()) {
            return;
        }
        if (this.cardinality.length < this.rangeCount()) {
            long[] replacement = new long[this.rangeCount()];
            System.arraycopy(this.cardinality, 0, replacement, 0, this.cardinality.length);
            this.cardinality = replacement;
        }
        assert (this.firstWrongCacheEntry >= 0) : this;
        long cumulative = this.firstWrongCacheEntry == 0 ? 0L : this.cardinality[this.firstWrongCacheEntry - 1];
        for (int i = this.firstWrongCacheEntry; i < this.rangeCount(); ++i) {
            this.cardinality[i] = cumulative += this.sortedRanges.get(i).size();
        }
        this.firstWrongCacheEntry = this.rangeCount();
        assert (this.cardinality.length >= this.rangeCount()) : this;
    }

    public RangeSet subsetForPositions(RangeSet positions, boolean reversed) {
        Range nextPosRange;
        if (reversed) {
            throw new UnsupportedOperationException("reversed=true");
        }
        if (positions.isEmpty() || this.isEmpty()) {
            return RangeSet.empty();
        }
        this.ensureCardinalityCache();
        ArrayList<Range> ranges = new ArrayList<Range>();
        Iterator<Range> positionsIter = positions.rangeIterator();
        int from = 0;
        while (positionsIter.hasNext() && (nextPosRange = positionsIter.next()).getFirst() <= this.size()) {
            long offset;
            Range target;
            if (nextPosRange.getFirst() == this.size()) {
                ranges.add(new Range(this.getLastRow(), this.getLastRow()));
                break;
            }
            long rangeToTake = nextPosRange.size();
            int pos = Arrays.binarySearch(this.cardinality, from, this.rangeCount(), nextPosRange.getFirst() + 1L);
            if (pos >= 0) {
                target = this.sortedRanges.get(pos);
                offset = 1L;
            } else {
                pos = -pos - 1;
                target = this.sortedRanges.get(pos);
                long c = this.cardinality[pos];
                offset = c - nextPosRange.getFirst();
            }
            assert (target != null) : String.valueOf(this) + ".subsetForPositions(" + String.valueOf(positions) + ")";
            assert (offset >= 0L && offset <= target.size()) : offset;
            long first = target.getLast() - offset + 1L;
            while (rangeToTake > 0L) {
                long count = Math.min(offset, rangeToTake);
                Range res = new Range(first, first + count - 1L);
                assert (count == res.size());
                ranges.add(res);
                rangeToTake -= count;
                if (++pos >= this.rangeCount()) break;
                target = this.sortedRanges.get(pos);
                first = target.getFirst();
                offset = target.size();
            }
            from = pos - 1;
        }
        RangeSet result = RangeSet.fromSortedRanges(ranges.toArray(new Range[0]));
        assert (result.size() <= positions.size());
        return result;
    }

    public RangeSet invert(RangeSet keys) {
        if (keys.isEmpty()) {
            return RangeSet.empty();
        }
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Keys not found: " + String.valueOf(keys));
        }
        this.ensureCardinalityCache();
        ArrayList<Range> positions = new ArrayList<Range>();
        int from = 0;
        Iterator<Range> keysIter = keys.rangeIterator();
        long startPos = -1L;
        long endPos = Long.MIN_VALUE;
        while (keysIter.hasNext()) {
            Range nextKeyRange = keysIter.next();
            int index = Collections.binarySearch(this.sortedRanges.subList(from, this.sortedRanges.size()), nextKeyRange);
            if (index < 0) {
                index = -index - 2;
            }
            if ((index += from) < 0) {
                throw new IllegalArgumentException("Key " + nextKeyRange.getFirst() + " not found");
            }
            Range target = this.sortedRanges.get(index);
            long newStartPos = (index == 0 ? 0L : this.cardinality[index - 1]) + (nextKeyRange.getFirst() - target.getFirst());
            if (newStartPos - 1L != endPos) {
                if (endPos != Long.MIN_VALUE) {
                    positions.add(new Range(startPos, endPos));
                }
                startPos = newStartPos;
            }
            endPos = newStartPos + (nextKeyRange.size() - 1L);
            from = index;
        }
        assert (endPos != Long.MIN_VALUE);
        positions.add(new Range(startPos, endPos));
        RangeSet result = RangeSet.fromSortedRanges(positions.toArray(new Range[0]));
        assert (result.size() == keys.size());
        return result;
    }

    public long get(long key) {
        if (key == 0L) {
            return this.getFirstRow();
        }
        if (key >= this.size()) {
            return -1L;
        }
        this.ensureCardinalityCache();
        int pos = Arrays.binarySearch(this.cardinality, 0, this.sortedRanges.size(), key);
        if (pos >= 0) {
            return this.sortedRanges.get(pos + 1).getFirst();
        }
        Range target = this.sortedRanges.get(-pos - 1);
        long c = this.cardinality[-pos - 1];
        long offset = c - key;
        assert (offset >= 0L);
        return target.getLast() - offset + 1L;
    }

    public RangeSet extract(RangeSet other) {
        RangeSet populatedCopy = this.copy();
        populatedCopy.removeRangeSet(other);
        RangeSet removed = this.copy();
        removed.removeRangeSet(populatedCopy);
        this.removeRangeSet(removed);
        return removed;
    }

    private static class RangeAccumulator {
        private final List<Range> replacement = new ArrayList<Range>();

        private RangeAccumulator() {
        }

        public void appendRange(Range range) {
            if (!this.replacement.isEmpty()) {
                Range lastSeen = this.replacement.get(this.replacement.size() - 1);
                Range overlap = lastSeen.overlap(range);
                if (overlap != null) {
                    this.replacement.set(this.replacement.size() - 1, overlap);
                } else {
                    this.replacement.add(range);
                }
            } else {
                this.replacement.add(range);
            }
        }

        public void appendRanges(List<Range> ranges) {
            this.appendRange(ranges.get(0));
            this.replacement.addAll(ranges.subList(0, ranges.size() - 1));
        }

        public void appendRanges(List<Range> ranges, long firstItemSubindex) {
            Range first = ranges.get(0);
            this.appendRange(new Range(first.getFirst() + firstItemSubindex, first.getLast()));
            this.replacement.addAll(ranges.subList(0, ranges.size() - 1));
        }

        public List<Range> build() {
            return this.replacement;
        }
    }

    private static class RangeIterator {
        private int index = -1;
        private final List<Range> ranges;
        private long key = 0L;

        private RangeIterator(List<Range> ranges) {
            this.ranges = ranges;
        }

        public void advanceInCurrentRangeToKey(long key) {
            assert (key != 0L);
            this.key = key;
        }

        public boolean hasNext() {
            return this.key == -1L || this.index < this.ranges.size() - 1;
        }

        public Range next() {
            if (this.key != 0L) {
                Range r = this.ranges.get(this.index);
                assert (this.key > r.getFirst() && this.key <= r.getLast());
                r = new Range(this.key, r.getLast());
                this.key = 0L;
                return r;
            }
            return this.ranges.get(++this.index);
        }
    }
}

