/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.web.shared.data;

import javax.annotation.Nonnull;

public class Range
implements Comparable<Range> {
    private final long first;
    private final long last;

    public Range(long first, long last) {
        this.first = first;
        this.last = last;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    @Override
    public int compareTo(@Nonnull Range o) {
        return Long.compare(this.first, o.first);
    }

    public Range overlap(Range range) {
        if (range.first > this.last + 1L || range.last < this.first - 1L) {
            return null;
        }
        return new Range(Math.min(this.first, range.first), Math.max(this.last, range.last));
    }

    public Range[] minus(Range range) {
        if (range.first > this.last || range.last < this.first) {
            return null;
        }
        if (range.first <= this.first && range.last >= this.last) {
            return new Range[0];
        }
        if (range.first > this.first && range.last < this.last) {
            return new Range[]{new Range(this.first, range.first - 1L), new Range(range.last + 1L, this.last)};
        }
        if (range.first <= this.first) {
            return new Range[]{new Range(range.last + 1L, this.last)};
        }
        return new Range[]{new Range(this.first, range.first - 1L)};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.first != range.first) {
            return false;
        }
        return this.last == range.last;
    }

    public int hashCode() {
        int result = (int)(this.first ^ this.first >>> 32);
        result = 31 * result + (int)(this.last ^ this.last >>> 32);
        return result;
    }

    public long size() {
        return this.last - this.first + 1L;
    }

    public String toString() {
        return "Range{first=" + this.first + ", last=" + this.last + "}";
    }

    public Range shift(long delta) {
        return new Range(this.first + delta, this.last + delta);
    }
}

