/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.web.shared.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class CustomColumnDescriptor
implements Serializable {
    private static final String VALID_ID_REGEX = "^[a-zA-Z_$][a-zA-Z0-9_$]*$";
    private String expression;
    private transient String name;

    private static String extractColumnName(String expression) {
        expression = expression.trim();
        String result = expression.split("=")[0].trim();
        assert (result.matches(VALID_ID_REGEX)) : "Invalid column name " + result + " extracted from " + expression;
        return result;
    }

    public String getExpression() {
        return this.expression;
    }

    public CustomColumnDescriptor setExpression(String expression) {
        this.expression = expression;
        this.name = null;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            this.name = CustomColumnDescriptor.extractColumnName(this.expression);
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomColumnDescriptor that = (CustomColumnDescriptor)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.name);
    }

    public static boolean isCompatible(List<CustomColumnDescriptor> was, List<CustomColumnDescriptor> is) {
        HashSet<String> existing = new HashSet<String>();
        for (CustomColumnDescriptor col : was) {
            existing.add(col.getName());
        }
        for (CustomColumnDescriptor col : is) {
            existing.remove(col.getName());
        }
        return existing.isEmpty();
    }

    public static List<CustomColumnDescriptor> from(String[] newCustomColumns) {
        HashSet<String> descriptorNames = new HashSet<String>();
        ArrayList<CustomColumnDescriptor> list = new ArrayList<CustomColumnDescriptor>();
        for (String col : newCustomColumns) {
            CustomColumnDescriptor descriptor = new CustomColumnDescriptor().setExpression(col);
            if (!descriptorNames.add(descriptor.getName())) {
                throw new IllegalArgumentException("Duplicate custom column: " + descriptor.getName());
            }
            list.add(descriptor);
        }
        return list;
    }

    public String toString() {
        return "CustomColumnDescriptor { " + this.expression + " }";
    }
}

