/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.util;

import io.deephaven.extensions.barrage.util.ExposedByteArrayOutputStream;
import io.grpc.MethodDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnaryInputStreamMarshaller
implements MethodDescriptor.Marshaller<InputStream> {
    public static UnaryInputStreamMarshaller INSTANCE = new UnaryInputStreamMarshaller();

    public InputStream stream(InputStream value) {
        return value;
    }

    public InputStream parse(InputStream stream) {
        ByteArrayInputStream byteArrayInputStream;
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            while (stream.available() > 0) {
                int len = stream.read(buffer);
                if (len <= 0) {
                    throw new IOException("failed to read from stream");
                }
                baos.write(buffer, 0, len);
            }
            byteArrayInputStream = new ByteArrayInputStream(baos.peekBuffer(), 0, baos.size());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse barrage message: ", e);
            }
        }
        baos.close();
        return byteArrayInputStream;
    }
}

