/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.util;

import io.deephaven.base.clock.Clock;
import io.deephaven.util.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public interface Scheduler
extends Clock {
    public void runAtTime(long var1, @NotNull Runnable var3);

    public void runAfterDelay(long var1, @NotNull Runnable var3);

    public void runImmediately(@NotNull Runnable var1);

    public void runSerially(@NotNull Runnable var1);

    default public boolean inTestMode() {
        return false;
    }

    public static class DelegatingImpl
    implements Scheduler {
        private final ExecutorService serialDelegate;
        private final ScheduledExecutorService concurrentDelegate;
        private final Clock clock;

        public DelegatingImpl(ExecutorService serialExecutor, ScheduledExecutorService concurrentExecutor, Clock clock) {
            this.serialDelegate = Objects.requireNonNull(serialExecutor);
            this.concurrentDelegate = Objects.requireNonNull(concurrentExecutor);
            this.clock = Objects.requireNonNull(clock);
        }

        @VisibleForTesting
        public void shutdown() throws InterruptedException {
            this.concurrentDelegate.shutdownNow();
            this.serialDelegate.shutdownNow();
            if (!this.concurrentDelegate.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("concurrentDelegate not shutdown within 5 seconds");
            }
            if (!this.serialDelegate.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("serialDelegate not shutdown within 5 seconds");
            }
        }

        public long currentTimeMillis() {
            return this.clock.currentTimeMillis();
        }

        public long currentTimeMicros() {
            return this.clock.currentTimeMicros();
        }

        public long currentTimeNanos() {
            return this.clock.currentTimeNanos();
        }

        public Instant instantNanos() {
            return this.clock.instantNanos();
        }

        public Instant instantMillis() {
            return this.clock.instantMillis();
        }

        @Override
        public void runAtTime(long epochMillis, @NotNull Runnable command) {
            this.runAfterDelay(epochMillis - this.clock.currentTimeMillis(), command);
        }

        @Override
        public void runImmediately(@NotNull Runnable command) {
            this.runAfterDelay(0L, command);
        }

        @Override
        public void runAfterDelay(long delayMs, @NotNull Runnable command) {
            this.concurrentDelegate.schedule(command, delayMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public void runSerially(@NotNull Runnable command) {
            this.serialDelegate.submit(command);
        }
    }
}

