/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.util;

import com.google.rpc.Code;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.browserstreaming.BrowserStream;
import io.deephaven.server.browserstreaming.BrowserStreamInterceptor;
import io.deephaven.server.browserstreaming.StreamData;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GrpcServiceOverrideBuilder {
    private final ServerServiceDefinition baseDefinition;
    private final List<GrpcOverride<?, ?>> overrides = new ArrayList();
    private final BrowserStreamInterceptor browserStreamInterceptor = new BrowserStreamInterceptor();
    private boolean needsBrowserInterceptor = false;

    private GrpcServiceOverrideBuilder(ServerServiceDefinition baseDefinition) {
        this.baseDefinition = baseDefinition;
    }

    public static GrpcServiceOverrideBuilder newBuilder(ServerServiceDefinition baseDefinition) {
        return new GrpcServiceOverrideBuilder(baseDefinition);
    }

    private <ReqT, RespT> GrpcServiceOverrideBuilder override(MethodDescriptor<ReqT, RespT> method, ServerCalls.BidiStreamingMethod<ReqT, RespT> handler) {
        GrpcServiceOverrideBuilder.validateMethodType(method.getType(), MethodDescriptor.MethodType.BIDI_STREAMING);
        this.overrides.add(new GrpcOverride<ReqT, RespT>(method, ServerCalls.asyncBidiStreamingCall(handler)));
        return this;
    }

    private <ReqT, RespT> GrpcServiceOverrideBuilder override(MethodDescriptor<ReqT, RespT> method, ServerCalls.ServerStreamingMethod<ReqT, RespT> handler) {
        GrpcServiceOverrideBuilder.validateMethodType(method.getType(), MethodDescriptor.MethodType.SERVER_STREAMING);
        this.overrides.add(new GrpcOverride<ReqT, RespT>(method, ServerCalls.asyncServerStreamingCall(handler)));
        return this;
    }

    private <ReqT, RespT> GrpcServiceOverrideBuilder override(MethodDescriptor<ReqT, RespT> method, ServerCalls.UnaryMethod<ReqT, RespT> handler) {
        GrpcServiceOverrideBuilder.validateMethodType(method.getType(), MethodDescriptor.MethodType.UNARY);
        this.overrides.add(new GrpcOverride<ReqT, RespT>(method, ServerCalls.asyncUnaryCall(handler)));
        return this;
    }

    public <ReqT, RespT> GrpcServiceOverrideBuilder onServerStreamingOverride(Delegate<ReqT, RespT> delegate, MethodDescriptor<?, ?> descriptor, MethodDescriptor.Marshaller<ReqT> requestMarshaller, MethodDescriptor.Marshaller<RespT> responseMarshaller) {
        return this.override(MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(descriptor.getFullMethodName()).setSampledToLocalTracing(false).setRequestMarshaller(requestMarshaller).setResponseMarshaller(responseMarshaller).setSchemaDescriptor(descriptor.getSchemaDescriptor()).build(), new OpenBrowserStreamMethod<ReqT, RespT>(delegate));
    }

    public <ReqT, RespT> GrpcServiceOverrideBuilder onBidiOverride(BidiDelegate<ReqT, RespT> delegate, MethodDescriptor<?, ?> descriptor, MethodDescriptor.Marshaller<ReqT> requestMarshaller, MethodDescriptor.Marshaller<RespT> responseMarshaller) {
        return this.override(MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(descriptor.getFullMethodName()).setSampledToLocalTracing(false).setRequestMarshaller(requestMarshaller).setResponseMarshaller(responseMarshaller).setSchemaDescriptor(descriptor.getSchemaDescriptor()).build(), new BidiStreamMethod<ReqT, RespT>(delegate));
    }

    public <ReqT, RespT, NextRespT> GrpcServiceOverrideBuilder onBidiOverrideWithBrowserSupport(BidiDelegate<ReqT, RespT> delegate, MethodDescriptor<?, ?> bidiDescriptor, MethodDescriptor<?, ?> openDescriptor, MethodDescriptor<?, ?> nextDescriptor, MethodDescriptor.Marshaller<ReqT> requestMarshaller, MethodDescriptor.Marshaller<RespT> responseMarshaller, MethodDescriptor.Marshaller<NextRespT> nextResponseMarshaller, BrowserStream.Mode mode, Logger log, SessionService sessionService) {
        return this.onBidiOverride(delegate, bidiDescriptor, requestMarshaller, responseMarshaller).onBidiBrowserSupport(delegate, openDescriptor, nextDescriptor, requestMarshaller, responseMarshaller, nextResponseMarshaller, mode, log, sessionService);
    }

    public <ReqT, RespT, NextRespT> GrpcServiceOverrideBuilder onBidiBrowserSupport(BidiDelegate<ReqT, RespT> delegate, MethodDescriptor<?, ?> openDescriptor, MethodDescriptor<?, ?> nextDescriptor, MethodDescriptor.Marshaller<ReqT> requestMarshaller, MethodDescriptor.Marshaller<RespT> responseMarshaller, MethodDescriptor.Marshaller<NextRespT> nextResponseMarshaller, BrowserStream.Mode mode, Logger log, SessionService sessionService) {
        BrowserStreamMethod method = new BrowserStreamMethod(log, mode, delegate, sessionService);
        this.needsBrowserInterceptor = true;
        return this.override(MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(openDescriptor.getFullMethodName()).setSampledToLocalTracing(false).setRequestMarshaller(requestMarshaller).setResponseMarshaller(responseMarshaller).setSchemaDescriptor(openDescriptor.getSchemaDescriptor()).build(), method.open()).override(MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(nextDescriptor.getFullMethodName()).setSampledToLocalTracing(false).setRequestMarshaller(requestMarshaller).setResponseMarshaller(nextResponseMarshaller).setSchemaDescriptor(nextDescriptor.getSchemaDescriptor()).build(), method.next());
    }

    public ServerServiceDefinition build() {
        String service = this.baseDefinition.getServiceDescriptor().getName();
        Set overrideMethodNames = this.overrides.stream().map(o -> o.method.getFullMethodName()).collect(Collectors.toSet());
        ServiceDescriptor.Builder serviceDescriptorBuilder = ServiceDescriptor.newBuilder((String)service).setSchemaDescriptor(this.baseDefinition.getServiceDescriptor().getSchemaDescriptor());
        this.overrides.forEach(o -> serviceDescriptorBuilder.addMethod(o.method));
        this.baseDefinition.getServiceDescriptor().getMethods().stream().filter(d -> !overrideMethodNames.contains(d.getFullMethodName())).forEach(arg_0 -> ((ServiceDescriptor.Builder)serviceDescriptorBuilder).addMethod(arg_0));
        ServiceDescriptor serviceDescriptor = serviceDescriptorBuilder.build();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)serviceDescriptor);
        this.overrides.forEach(dp -> dp.addMethod(serviceBuilder));
        this.baseDefinition.getMethods().stream().filter(d -> !overrideMethodNames.contains(d.getMethodDescriptor().getFullMethodName())).forEach(arg_0 -> ((ServerServiceDefinition.Builder)serviceBuilder).addMethod(arg_0));
        ServerServiceDefinition serviceDef = serviceBuilder.build();
        if (this.needsBrowserInterceptor) {
            return ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])new ServerInterceptor[]{this.browserStreamInterceptor});
        }
        return serviceDef;
    }

    private static void validateMethodType(MethodDescriptor.MethodType methodType, MethodDescriptor.MethodType handlerType) {
        if (methodType != handlerType) {
            throw new IllegalArgumentException("Provided method's type (" + methodType.name() + ") does not match handler's type of " + handlerType.name());
        }
    }

    private static class GrpcOverride<ReqT, RespT> {
        private final MethodDescriptor<ReqT, RespT> method;
        private final ServerCallHandler<ReqT, RespT> handler;

        private GrpcOverride(@NotNull MethodDescriptor<ReqT, RespT> method, @NotNull ServerCallHandler<ReqT, RespT> handler) {
            this.method = method;
            this.handler = handler;
        }

        private void addMethod(ServerServiceDefinition.Builder builder) {
            builder.addMethod(this.method, this.handler);
        }
    }

    public static class OpenBrowserStreamMethod<ReqT, RespT>
    implements ServerCalls.ServerStreamingMethod<ReqT, RespT> {
        private final Delegate<ReqT, RespT> delegate;

        public OpenBrowserStreamMethod(Delegate<ReqT, RespT> delegate) {
            this.delegate = delegate;
        }

        public void invoke(ReqT request, StreamObserver<RespT> responseObserver) {
            ServerCallStreamObserver serverCall = (ServerCallStreamObserver)responseObserver;
            serverCall.disableAutoInboundFlowControl();
            serverCall.request(Integer.MAX_VALUE);
            this.delegate.doInvoke(request, responseObserver);
        }
    }

    @FunctionalInterface
    public static interface Delegate<ReqT, RespT> {
        public void doInvoke(ReqT var1, StreamObserver<RespT> var2);
    }

    public static class BidiStreamMethod<ReqT, RespT>
    implements ServerCalls.BidiStreamingMethod<ReqT, RespT> {
        private final BidiDelegate<ReqT, RespT> delegate;

        public BidiStreamMethod(BidiDelegate<ReqT, RespT> delegate) {
            this.delegate = delegate;
        }

        public StreamObserver<ReqT> invoke(StreamObserver<RespT> responseObserver) {
            ServerCallStreamObserver serverCall = (ServerCallStreamObserver)responseObserver;
            serverCall.disableAutoInboundFlowControl();
            serverCall.request(Integer.MAX_VALUE);
            return this.delegate.doInvoke(responseObserver);
        }
    }

    @FunctionalInterface
    public static interface BidiDelegate<ReqT, RespT> {
        public StreamObserver<ReqT> doInvoke(StreamObserver<RespT> var1);
    }

    public static final class BrowserStreamMethod<ReqT, RespT, NextRespT> {
        private final BrowserStream.Factory<ReqT, RespT> factory;
        private final SessionService sessionService;
        private final Logger log;

        public BrowserStreamMethod(Logger log, BrowserStream.Mode mode, BidiDelegate<ReqT, RespT> delegate, SessionService sessionService) {
            this.log = log;
            this.factory = BrowserStream.factory(mode, delegate);
            this.sessionService = sessionService;
        }

        public ServerCalls.ServerStreamingMethod<ReqT, RespT> open() {
            return this::invokeOpen;
        }

        public ServerCalls.UnaryMethod<ReqT, NextRespT> next() {
            return this::invokeNext;
        }

        public void invokeOpen(@NotNull ReqT request, @NotNull StreamObserver<RespT> responseObserver) {
            StreamData streamData = (StreamData)StreamData.STREAM_DATA_KEY.get();
            SessionState session = this.sessionService.getCurrentSession();
            if (streamData == null) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"no x-deephaven-stream headers, cannot handle open request");
            }
            BrowserStream browserStream = this.factory.create(session, responseObserver);
            browserStream.onMessageReceived(request, streamData);
            if (!streamData.isHalfClose()) {
                session.newExport(streamData.getRpcTicket(), "rpcTicket").submit(() -> browserStream);
            }
        }

        public void invokeNext(@NotNull ReqT request, @NotNull StreamObserver<NextRespT> responseObserver) {
            StreamData streamData = (StreamData)StreamData.STREAM_DATA_KEY.get();
            if (streamData == null || streamData.getRpcTicket() == null) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"no x-deephaven-stream headers, cannot handle next request");
            }
            SessionState session = this.sessionService.getCurrentSession();
            SessionState.ExportObject browserStream = session.getExport(streamData.getRpcTicket(), "rpcTicket");
            session.nonExport().require(browserStream).onError(responseObserver).submit(() -> {
                ((BrowserStream)browserStream.get()).onMessageReceived(request, streamData);
                responseObserver.onNext(null);
                responseObserver.onCompleted();
            });
        }
    }
}

