/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.uri;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.uri.QueryScopeUri;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolversInstance;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public final class QueryScopeResolver
implements UriResolver {
    public static QueryScopeResolver get() {
        return (QueryScopeResolver)UriResolversInstance.get().find(QueryScopeResolver.class).get();
    }

    @Inject
    public QueryScopeResolver() {
    }

    public Set<String> schemes() {
        return Collections.singleton("dh");
    }

    public boolean isResolvable(URI uri) {
        return QueryScopeUri.isWellFormed((URI)uri);
    }

    public Object resolve(URI uri) {
        return this.resolve(QueryScopeUri.of((URI)uri));
    }

    public Object resolve(QueryScopeUri uri) {
        return this.resolve(uri.variableName());
    }

    public Object resolve(String variableName) {
        return ExecutionContext.getContext().getQueryScope().readParamValue(variableName, null);
    }
}

