/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.uri;

import io.deephaven.engine.table.Table;
import io.deephaven.parquet.table.ParquetTools;
import io.deephaven.uri.UriHelper;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolversInstance;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public final class ParquetTableResolver
implements UriResolver {
    public static final String SCHEME = "parquet";
    private static final Set<String> SCHEMES = Collections.singleton("parquet");

    public static boolean isWellFormed(URI uri) {
        return SCHEME.equals(uri.getScheme()) && UriHelper.isLocalPath((URI)uri);
    }

    public static ParquetTableResolver get() {
        return (ParquetTableResolver)UriResolversInstance.get().find(ParquetTableResolver.class).get();
    }

    @Inject
    public ParquetTableResolver() {
    }

    public Set<String> schemes() {
        return SCHEMES;
    }

    public boolean isResolvable(URI uri) {
        return ParquetTableResolver.isWellFormed(uri);
    }

    public Table resolve(URI uri) throws InterruptedException {
        if (!ParquetTableResolver.isWellFormed(uri)) {
            throw new IllegalArgumentException(String.format("Invalid parquet URI '%s'", uri));
        }
        return ParquetTools.readTable((String)uri.getPath());
    }
}

