/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.uri;

import io.deephaven.csv.CsvTools;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.engine.table.Table;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolversInstance;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

public final class CsvTableResolver
implements UriResolver {
    private static final Set<String> SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("csv+http", "http+csv", "csv+https", "https+csv", "csv+file", "file+csv", "csv")));

    public static CsvTableResolver get() {
        return (CsvTableResolver)UriResolversInstance.get().find(CsvTableResolver.class).get();
    }

    @Inject
    public CsvTableResolver() {
    }

    public Set<String> schemes() {
        return SCHEMES;
    }

    public boolean isResolvable(URI uri) {
        return SCHEMES.contains(uri.getScheme());
    }

    public Table resolve(URI uri) {
        try {
            return this.read(uri);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Table read(URI uri) throws IOException {
        try {
            return CsvTools.readCsv((String)CsvTableResolver.csvString(uri));
        }
        catch (CsvReaderException inner) {
            throw new RuntimeException("Caught exception", inner);
        }
    }

    private static String csvString(URI uri) {
        String scheme;
        switch (scheme = uri.getScheme()) {
            case "csv+http": 
            case "http+csv": {
                return CsvTableResolver.replaceScheme(uri, "http");
            }
            case "csv+https": 
            case "https+csv": {
                return CsvTableResolver.replaceScheme(uri, "https");
            }
            case "csv+file": 
            case "file+csv": 
            case "csv": {
                return CsvTableResolver.replaceScheme(uri, "file");
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected scheme '%s'", scheme));
    }

    private static String replaceScheme(URI other, String newScheme) {
        try {
            return new URI(newScheme, other.getUserInfo(), other.getHost(), other.getPort(), other.getPath(), other.getQuery(), other.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

