/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.uri;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.client.impl.BarrageSession;
import io.deephaven.client.impl.BarrageSubscription;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.Table;
import io.deephaven.extensions.barrage.BarrageSnapshotOptions;
import io.deephaven.extensions.barrage.BarrageSubscriptionOptions;
import io.deephaven.qst.table.TableSpec;
import io.deephaven.qst.table.TicketTable;
import io.deephaven.server.session.SessionFactoryCreator;
import io.deephaven.uri.ApplicationUri;
import io.deephaven.uri.DeephavenTarget;
import io.deephaven.uri.FieldUri;
import io.deephaven.uri.QueryScopeUri;
import io.deephaven.uri.RemoteUri;
import io.deephaven.uri.StructuredUri;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolversInstance;
import java.net.URI;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class BarrageTableResolver
implements UriResolver {
    public static final Integer MAX_INBOUND_MESSAGE_SIZE = Configuration.getInstance().getIntegerWithDefault("BarrageTableResolver.maxInboundMessageSize", 0x6400000);
    public static final BarrageSubscriptionOptions SUB_OPTIONS = BarrageSubscriptionOptions.builder().useDeephavenNulls(true).build();
    public static final BarrageSnapshotOptions SNAP_OPTIONS = BarrageSnapshotOptions.builder().useDeephavenNulls(true).build();
    private static final Set<String> SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dh", "dh+plain")));
    private final SessionFactoryCreator sessionFactoryCreator;
    private final Map<DeephavenTarget, BarrageSession> sessions;

    public static BarrageTableResolver get() {
        return (BarrageTableResolver)UriResolversInstance.get().find(BarrageTableResolver.class).get();
    }

    @Inject
    public BarrageTableResolver(SessionFactoryCreator sessionFactoryCreator) {
        this.sessionFactoryCreator = Objects.requireNonNull(sessionFactoryCreator);
        this.sessions = new ConcurrentHashMap<DeephavenTarget, BarrageSession>();
    }

    public Set<String> schemes() {
        return SCHEMES;
    }

    public boolean isResolvable(URI uri) {
        return RemoteUri.isWellFormed((URI)uri);
    }

    public Table resolve(URI uri) throws InterruptedException {
        try {
            return this.subscribe(RemoteUri.of((URI)uri)).get();
        }
        catch (TableHandle.TableHandleException e) {
            throw e.asUnchecked();
        }
        catch (ExecutionException e) {
            throw new UncheckedDeephavenException((Throwable)e);
        }
    }

    public Future<Table> subscribe(RemoteUri remoteUri) throws InterruptedException, TableHandle.TableHandleException {
        DeephavenTarget target = remoteUri.target();
        TableSpec table = RemoteResolver.of(remoteUri);
        return this.subscribe(target, table, SUB_OPTIONS);
    }

    public Future<Table> subscribe(String targetUri, TableSpec table) throws TableHandle.TableHandleException, InterruptedException {
        return this.subscribe(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS);
    }

    public Future<Table> subscribe(DeephavenTarget target, TableSpec table, BarrageSubscriptionOptions options) throws TableHandle.TableHandleException, InterruptedException {
        BarrageSession session = this.session(target);
        BarrageSubscription sub = session.subscribe(table, options);
        return sub.entireTable();
    }

    public Future<Table> subscribe(String targetUri, TableSpec table, RowSet viewport, BitSet columns) throws TableHandle.TableHandleException, InterruptedException {
        return this.subscribe(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS, viewport, columns, false);
    }

    public Future<Table> subscribe(String targetUri, TableSpec table, RowSet viewport, BitSet columns, boolean reverseViewport) throws TableHandle.TableHandleException, InterruptedException {
        return this.subscribe(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS, viewport, columns, reverseViewport);
    }

    public Future<Table> subscribe(DeephavenTarget target, TableSpec table, BarrageSubscriptionOptions options, RowSet viewport, BitSet columns, boolean reverseViewport) throws TableHandle.TableHandleException, InterruptedException {
        BarrageSession session = this.session(target);
        BarrageSubscription sub = session.subscribe(table, options);
        return sub.partialTable(viewport, columns, reverseViewport);
    }

    public Future<Table> snapshot(RemoteUri remoteUri) throws InterruptedException, TableHandle.TableHandleException {
        DeephavenTarget target = remoteUri.target();
        TableSpec table = RemoteResolver.of(remoteUri);
        return this.snapshot(target, table, SUB_OPTIONS);
    }

    public Future<Table> snapshot(String targetUri, TableSpec table) throws TableHandle.TableHandleException, InterruptedException {
        return this.snapshot(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS);
    }

    public Future<Table> snapshot(DeephavenTarget target, TableSpec table, BarrageSubscriptionOptions options) throws TableHandle.TableHandleException, InterruptedException {
        BarrageSession session = this.session(target);
        return session.subscribe(table, options).snapshotEntireTable();
    }

    public Future<Table> snapshot(String targetUri, TableSpec table, RowSet viewport, BitSet columns) throws TableHandle.TableHandleException, InterruptedException {
        return this.snapshot(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS, viewport, columns, false);
    }

    public Future<Table> snapshot(String targetUri, TableSpec table, RowSet viewport, BitSet columns, boolean reverseViewport) throws TableHandle.TableHandleException, InterruptedException {
        return this.snapshot(DeephavenTarget.of((URI)URI.create(targetUri)), table, SUB_OPTIONS, viewport, columns, reverseViewport);
    }

    public Future<Table> snapshot(DeephavenTarget target, TableSpec table, BarrageSubscriptionOptions options, RowSet viewport, BitSet columns, boolean reverseViewport) throws TableHandle.TableHandleException, InterruptedException {
        BarrageSession session = this.session(target);
        return session.subscribe(table, options).snapshotPartialTable(viewport, columns, reverseViewport);
    }

    private BarrageSession session(DeephavenTarget target) {
        return this.sessions.computeIfAbsent(target, this::newSession);
    }

    private BarrageSession newSession(DeephavenTarget target) {
        return this.newSession(ClientConfig.builder().target(target).maxInboundMessageSize(MAX_INBOUND_MESSAGE_SIZE.intValue()).build());
    }

    private BarrageSession newSession(ClientConfig config) {
        return this.sessionFactoryCreator.barrageFactory(config).newBarrageSession();
    }

    static class RemoteResolver
    implements StructuredUri.Visitor {
        private final DeephavenTarget target;
        private TableSpec out;

        public static TableSpec of(RemoteUri remoteUri) {
            return ((RemoteResolver)remoteUri.uri().walk((StructuredUri.Visitor)new RemoteResolver(remoteUri.target()))).out();
        }

        public RemoteResolver(DeephavenTarget target) {
            this.target = Objects.requireNonNull(target);
        }

        public TableSpec out() {
            return Objects.requireNonNull(this.out);
        }

        public void visit(FieldUri fieldUri) {
            this.out = TicketTable.fromApplicationField((String)this.target.host(), (String)fieldUri.fieldName());
        }

        public void visit(ApplicationUri applicationField) {
            this.out = TicketTable.fromApplicationField((String)applicationField.applicationId(), (String)applicationField.fieldName());
        }

        public void visit(QueryScopeUri queryScope) {
            this.out = TicketTable.fromQueryScopeField((String)queryScope.variableName());
        }

        public void visit(RemoteUri remoteUri) {
            throw new UnsupportedOperationException("Proxying not supported yet, see https://github.com/deephaven/deephaven-core/issues/1483");
        }

        public void visit(URI customUri) {
            throw new UnsupportedOperationException("Remote custom URIs not supported yet, see https://github.com/deephaven/deephaven-core/issues/1483");
        }
    }
}

