/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.uri;

import io.deephaven.appmode.ApplicationState;
import io.deephaven.appmode.Field;
import io.deephaven.server.appmode.ApplicationStates;
import io.deephaven.uri.ApplicationUri;
import io.deephaven.uri.resolver.UriResolver;
import io.deephaven.uri.resolver.UriResolversInstance;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public final class ApplicationResolver
implements UriResolver {
    private final ApplicationStates states;

    public static ApplicationResolver get() {
        return (ApplicationResolver)UriResolversInstance.get().find(ApplicationResolver.class).get();
    }

    @Inject
    public ApplicationResolver(ApplicationStates states) {
        this.states = Objects.requireNonNull(states);
    }

    public Set<String> schemes() {
        return Collections.singleton("dh");
    }

    public boolean isResolvable(URI uri) {
        return ApplicationUri.isWellFormed((URI)uri);
    }

    public Object resolve(URI uri) {
        Field<Object> field = this.resolve(ApplicationUri.of((URI)uri));
        return field == null ? null : field.value();
    }

    public Field<Object> resolve(ApplicationUri uri) {
        return this.resolve(uri.applicationId(), uri.fieldName());
    }

    public Field<Object> resolve(String applicationId, String fieldName) {
        ApplicationState app = this.states.getApplicationState(applicationId).orElse(null);
        return app == null ? null : app.getField(fieldName);
    }
}

