/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.validation;

import dagger.Module;
import dagger.Provides;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.engine.validation.MethodInvocationValidator;
import io.deephaven.server.table.validation.AnnotationMethodInvocationValidator;
import io.deephaven.server.table.validation.CachingMethodInvocationValidator;
import io.deephaven.server.table.validation.MethodNameColumnExpressionValidator;
import io.deephaven.server.table.validation.ParsingColumnExpressionValidator;
import io.deephaven.server.table.validation.methodlist.MethodListInvocationValidator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Module
public class ExpressionValidatorModule {
    @Provides
    public ColumnExpressionValidator provideExpressionValidator() {
        Configuration configuration = Configuration.getInstance();
        String expressionValidator = configuration.getStringWithDefault("ColumnExpressionValidator", "parsed");
        if (expressionValidator.equals("method_name")) {
            return new MethodNameColumnExpressionValidator();
        }
        if (expressionValidator.equals("parsed")) {
            return ExpressionValidatorModule.getParsingColumnExpressionValidatorFromConfiguration(configuration);
        }
        throw new IllegalArgumentException("Unsupported column expression: " + expressionValidator);
    }

    @NotNull
    public static ParsingColumnExpressionValidator getParsingColumnExpressionValidatorFromConfiguration(Configuration configuration) {
        List<String> methodList = ExpressionValidatorModule.getMethodListFromConfiguration(configuration);
        MethodListInvocationValidator listValidator = new MethodListInvocationValidator(methodList);
        AnnotationMethodInvocationValidator annotationValidator = new AnnotationMethodInvocationValidator(ExpressionValidatorModule.getAnnotationSets(configuration, "ColumnExpressionValidator.annotationSets."));
        return new ParsingColumnExpressionValidator(List.of(new CachingMethodInvocationValidator((MethodInvocationValidator)annotationValidator), new CachingMethodInvocationValidator((MethodInvocationValidator)listValidator)));
    }

    public static List<String> getMethodListFromConfiguration(Configuration configuration) {
        return configuration.getProperties("ColumnExpressionValidator.allowedMethods.").values().stream().flatMap(x -> Arrays.stream(((String)x).split(";"))).map(String::trim).collect(Collectors.toUnmodifiableList());
    }

    private static Set<String> getAnnotationSets(Configuration configuration, String prefix) {
        HashSet<String> allowedSets = new HashSet<String>();
        configuration.getProperties(prefix).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Arrays.stream(((String)v).split(",")).map(String::trim).forEach(allowedSets::add)));
        return allowedSets;
    }
}

