/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import gnu.trove.map.hash.TObjectLongHashMap;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.table.iterators.ChunkedObjectColumnIterator;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedStatsKernel;
import io.deephaven.util.type.ArrayTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ObjectChunkedStats
implements ChunkedStatsKernel {
    private final int maxUniqueToCollect;
    private final int maxUniqueToDisplay;

    public ObjectChunkedStats(int maxUniqueToCollect, int maxUniqueToDisplay) {
        this.maxUniqueToCollect = maxUniqueToCollect;
        this.maxUniqueToDisplay = maxUniqueToDisplay;
    }

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        long count = 0L;
        int uniqueCount = 0;
        TObjectLongHashMap countValues = new TObjectLongHashMap();
        boolean useSet = false;
        HashSet<Object> uniqueValues = new HashSet<Object>();
        try (ChunkedObjectColumnIterator iterator = new ChunkedObjectColumnIterator((ChunkSource)(usePrev ? columnSource.getPrevSource() : columnSource), (RowSequence)rowSet);){
            Object val;
            while (iterator.hasNext()) {
                val = iterator.next();
                if (val == null) continue;
                ++count;
                if (countValues.adjustOrPutValue(val, 1L, 1L) != 1L || ++uniqueCount <= this.maxUniqueToCollect) continue;
                uniqueValues.addAll(countValues.keySet());
                countValues.clear();
                useSet = true;
                break;
            }
            while (iterator.hasNext()) {
                val = iterator.next();
                if (val == null) continue;
                ++count;
                uniqueValues.add(val);
            }
        }
        if (useSet) {
            return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.intCol((String)"UNIQUE_VALUES", (int[])new int[]{uniqueValues.size()})});
        }
        ArrayList sorted = new ArrayList(countValues.size());
        if (columnSource.getType().isArray()) {
            countValues.forEachEntry((o, c) -> {
                sorted.add(Map.entry(ArrayTypeUtils.toString((Object)o), c));
                return true;
            });
        } else {
            countValues.forEachEntry((o, c) -> {
                sorted.add(Map.entry(Objects.toString(o), c));
                return true;
            });
        }
        sorted.sort(Map.Entry.comparingByValue().reversed());
        int resultCount = Math.min(this.maxUniqueToDisplay, sorted.size());
        String[] uniqueKeys = new String[resultCount];
        long[] uniqueCounts = new long[resultCount];
        Iterator iter = sorted.iterator();
        for (int i = 0; i < resultCount; ++i) {
            Map.Entry entry = (Map.Entry)iter.next();
            uniqueKeys[i] = (String)entry.getKey();
            uniqueCounts[i] = (Long)entry.getValue();
        }
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.intCol((String)"UNIQUE_VALUES", (int[])new int[]{countValues.size()}), new ColumnHolder("UNIQUE_KEYS", String[].class, String.class, false, (Object[])new String[][]{uniqueKeys}), new ColumnHolder("UNIQUE_COUNTS", long[].class, Long.TYPE, false, (Object[])new long[][]{uniqueCounts})});
    }
}

