/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.chunk.IntChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;

public class IntegerChunkedNumericalStats
implements ChunkedNumericalStatsKernel {
    private long count = 0L;
    private long sum = 0L;
    private boolean useFloatingSum = false;
    private double floatingSum = 0.0;
    private long absSum = 0L;
    private boolean useFloatingAbsSum = false;
    private double floatingAbsSum = 0.0;
    private long sumOfSquares = 0L;
    private boolean useFloatingSumOfSquares = false;
    private double floatingSumOfSquares = 0.0;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MIN_VALUE;
    private int absMin = Integer.MIN_VALUE;
    private int absMax = Integer.MIN_VALUE;

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        try (ChunkSource.GetContext getContext = columnSource.makeGetContext(2048);){
            RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();
            while (rsIt.hasMore()) {
                RowSequence nextKeys = rsIt.getNextRowSequenceWithLength(2048L);
                IntChunk chunk = (usePrev ? columnSource.getPrevChunk(getContext, nextKeys) : columnSource.getChunk(getContext, nextKeys)).asIntChunk();
                double chunkedOverflowSum = 0.0;
                double chunkedOverflowAbsSum = 0.0;
                double chunkedOverflowSumOfSquares = 0.0;
                int chunkSize = chunk.size();
                for (int ii = 0; ii < chunkSize; ++ii) {
                    int val = chunk.get(ii);
                    if (val == Integer.MIN_VALUE) continue;
                    int absVal = Math.abs(val);
                    if (this.count == 0L) {
                        this.min = this.max = val;
                        this.absMax = this.absMin = absVal;
                    } else {
                        if (val < this.min) {
                            this.min = val;
                        }
                        if (val > this.max) {
                            this.max = val;
                        }
                        if (absVal < this.absMin) {
                            this.absMin = absVal;
                        }
                        if (absVal > this.absMax) {
                            this.absMax = absVal;
                        }
                    }
                    ++this.count;
                    if (!this.useFloatingSum) {
                        try {
                            this.sum = Math.addExact(this.sum, (long)val);
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingSum = true;
                            this.floatingSum = this.sum;
                            chunkedOverflowSum = val;
                        }
                    } else {
                        chunkedOverflowSum += (double)val;
                    }
                    if (!this.useFloatingAbsSum) {
                        try {
                            this.absSum = Math.addExact(this.absSum, (long)absVal);
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingAbsSum = true;
                            this.floatingAbsSum = this.absSum;
                            chunkedOverflowAbsSum = absVal;
                        }
                    } else {
                        chunkedOverflowAbsSum += (double)absVal;
                    }
                    if (!this.useFloatingSumOfSquares) {
                        try {
                            this.sumOfSquares = Math.addExact(this.sumOfSquares, (long)Math.multiplyExact(val, val));
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingSumOfSquares = true;
                            this.floatingSumOfSquares = this.sumOfSquares;
                            chunkedOverflowSumOfSquares = Math.pow(val, 2.0);
                        }
                        continue;
                    }
                    chunkedOverflowSumOfSquares += Math.pow(val, 2.0);
                }
                if (this.useFloatingSum) {
                    this.floatingSum += chunkedOverflowSum;
                }
                if (this.useFloatingAbsSum) {
                    this.floatingAbsSum += chunkedOverflowAbsSum;
                }
                if (!this.useFloatingSumOfSquares) continue;
                this.floatingSumOfSquares += chunkedOverflowSumOfSquares;
            }
        }
        double avg = this.avg(this.count, this.useFloatingSum ? this.floatingSum : (double)this.sum);
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{this.count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), this.useFloatingSum ? TableTools.doubleCol((String)"SUM", (double[])new double[]{this.floatingSum}) : TableTools.longCol((String)"SUM", (long[])new long[]{this.sum}), this.useFloatingAbsSum ? TableTools.doubleCol((String)"SUM_ABS", (double[])new double[]{this.floatingAbsSum}) : TableTools.longCol((String)"SUM_ABS", (long[])new long[]{this.absSum}), this.useFloatingSumOfSquares ? TableTools.doubleCol((String)"SQRD_SUM", (double[])new double[]{this.floatingSumOfSquares}) : TableTools.longCol((String)"SUM_SQRD", (long[])new long[]{this.sumOfSquares}), TableTools.intCol((String)"MIN", (int[])new int[]{this.min}), TableTools.intCol((String)"MAX", (int[])new int[]{this.max}), TableTools.intCol((String)"MIN_ABS", (int[])new int[]{this.absMin}), TableTools.intCol((String)"MAX_ABS", (int[])new int[]{this.absMax}), TableTools.doubleCol((String)"AVG", (double[])new double[]{avg}), TableTools.doubleCol((String)"AVG_ABS", (double[])new double[]{this.avg(this.count, this.absSum)}), TableTools.doubleCol((String)"STD_DEV", (double[])new double[]{this.stdDev(this.count, this.useFloatingSum ? this.floatingSum : (double)this.sum, this.useFloatingSumOfSquares ? this.floatingSumOfSquares : (double)this.sumOfSquares)})});
    }
}

