/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.chunk.FloatChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;

public class FloatChunkedNumericalStats
implements ChunkedNumericalStatsKernel {
    private long count = 0L;
    private double sum = 0.0;
    private double absSum = 0.0;
    private double sumOfSquares = 0.0;
    private float min = -3.4028235E38f;
    private float max = -3.4028235E38f;
    private float absMin = -3.4028235E38f;
    private float absMax = -3.4028235E38f;

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        try (ChunkSource.GetContext getContext = columnSource.makeGetContext(2048);){
            RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();
            while (rsIt.hasMore()) {
                RowSequence nextKeys = rsIt.getNextRowSequenceWithLength(2048L);
                FloatChunk chunk = (usePrev ? columnSource.getPrevChunk(getContext, nextKeys) : columnSource.getChunk(getContext, nextKeys)).asFloatChunk();
                double chunkedSum = 0.0;
                double chunkedAbsSum = 0.0;
                double chunkedSumOfSquares = 0.0;
                int chunkSize = chunk.size();
                for (int ii = 0; ii < chunkSize; ++ii) {
                    float val = chunk.get(ii);
                    if (val == -3.4028235E38f) continue;
                    float absVal = Math.abs(val);
                    if (this.count == 0L) {
                        this.min = this.max = val;
                        this.absMax = this.absMin = absVal;
                    } else {
                        if (val < this.min) {
                            this.min = val;
                        }
                        if (val > this.max) {
                            this.max = val;
                        }
                        if (absVal < this.absMin) {
                            this.absMin = absVal;
                        }
                        if (absVal > this.absMax) {
                            this.absMax = absVal;
                        }
                    }
                    ++this.count;
                    chunkedSum += (double)val;
                    chunkedAbsSum += (double)absVal;
                    chunkedSumOfSquares += (double)val * (double)val;
                }
                this.sum += chunkedSum;
                this.absSum += chunkedAbsSum;
                this.sumOfSquares += chunkedSumOfSquares;
            }
        }
        double avg = this.avg(this.count, this.sum);
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{this.count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.doubleCol((String)"SUM", (double[])new double[]{this.sum}), TableTools.doubleCol((String)"SUM_ABS", (double[])new double[]{this.absSum}), TableTools.doubleCol((String)"SUM_SQRD", (double[])new double[]{this.sumOfSquares}), TableTools.floatCol((String)"MIN", (float[])new float[]{this.min}), TableTools.floatCol((String)"MAX", (float[])new float[]{this.max}), TableTools.floatCol((String)"MIN_ABS", (float[])new float[]{this.absMin}), TableTools.floatCol((String)"MAX_ABS", (float[])new float[]{this.absMax}), TableTools.doubleCol((String)"AVG", (double[])new double[]{avg}), TableTools.doubleCol((String)"AVG_ABS", (double[])new double[]{this.avg(this.count, this.absSum)}), TableTools.doubleCol((String)"STD_DEV", (double[])new double[]{this.stdDev(this.count, this.sum, this.sumOfSquares)})});
    }
}

