/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.chunk.DoubleChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;

public class DoubleChunkedNumericalStats
implements ChunkedNumericalStatsKernel {
    private long count = 0L;
    private double sum = 0.0;
    private double absSum = 0.0;
    private double sumOfSquares = 0.0;
    private double min = -1.7976931348623157E308;
    private double max = -1.7976931348623157E308;
    private double absMin = -1.7976931348623157E308;
    private double absMax = -1.7976931348623157E308;

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        try (ChunkSource.GetContext getContext = columnSource.makeGetContext(2048);){
            RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();
            while (rsIt.hasMore()) {
                RowSequence nextKeys = rsIt.getNextRowSequenceWithLength(2048L);
                DoubleChunk chunk = (usePrev ? columnSource.getPrevChunk(getContext, nextKeys) : columnSource.getChunk(getContext, nextKeys)).asDoubleChunk();
                double chunkedSum = 0.0;
                double chunkedAbsSum = 0.0;
                double chunkedSumOfSquares = 0.0;
                int chunkSize = chunk.size();
                for (int ii = 0; ii < chunkSize; ++ii) {
                    double val = chunk.get(ii);
                    if (val == -1.7976931348623157E308) continue;
                    double absVal = Math.abs(val);
                    if (this.count == 0L) {
                        this.min = this.max = val;
                        this.absMax = this.absMin = absVal;
                    } else {
                        if (val < this.min) {
                            this.min = val;
                        }
                        if (val > this.max) {
                            this.max = val;
                        }
                        if (absVal < this.absMin) {
                            this.absMin = absVal;
                        }
                        if (absVal > this.absMax) {
                            this.absMax = absVal;
                        }
                    }
                    ++this.count;
                    chunkedSum += val;
                    chunkedAbsSum += absVal;
                    chunkedSumOfSquares += val * val;
                }
                this.sum += chunkedSum;
                this.absSum += chunkedAbsSum;
                this.sumOfSquares += chunkedSumOfSquares;
            }
        }
        double avg = this.avg(this.count, this.sum);
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{this.count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.doubleCol((String)"SUM", (double[])new double[]{this.sum}), TableTools.doubleCol((String)"SUM_ABS", (double[])new double[]{this.absSum}), TableTools.doubleCol((String)"SUM_SQRD", (double[])new double[]{this.sumOfSquares}), TableTools.doubleCol((String)"MIN", (double[])new double[]{this.min}), TableTools.doubleCol((String)"MAX", (double[])new double[]{this.max}), TableTools.doubleCol((String)"MIN_ABS", (double[])new double[]{this.absMin}), TableTools.doubleCol((String)"MAX_ABS", (double[])new double[]{this.absMax}), TableTools.doubleCol((String)"AVG", (double[])new double[]{avg}), TableTools.doubleCol((String)"AVG_ABS", (double[])new double[]{this.avg(this.count, this.absSum)}), TableTools.doubleCol((String)"STD_DEV", (double[])new double[]{this.stdDev(this.count, this.sum, this.sumOfSquares)})});
    }
}

