/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.table.iterators.ChunkedLongColumnIterator;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedStatsKernel;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;

public class DateTimeChunkedStats
implements ChunkedStatsKernel {
    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        long count = 0L;
        long min = Long.MIN_VALUE;
        long max = Long.MIN_VALUE;
        try (ChunkedLongColumnIterator iterator = new ChunkedLongColumnIterator((ChunkSource)(usePrev ? columnSource.getPrevSource() : columnSource), (RowSequence)rowSet);){
            while (iterator.hasNext()) {
                long val = iterator.nextLong();
                if (val == Long.MIN_VALUE) continue;
                if (count == 0L) {
                    min = max = val;
                } else {
                    if (val < min) {
                        min = val;
                    }
                    if (val > max) {
                        max = val;
                    }
                }
                ++count;
            }
        }
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.instantCol((String)"MIN", (Instant[])new Instant[]{DateTimeUtils.epochNanosToInstant((long)min)}), TableTools.instantCol((String)"MAX", (Instant[])new Instant[]{DateTimeUtils.epochNanosToInstant((long)max)})});
    }
}

