/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.server.table.stats.BigDecimalChunkedNumericalStats;
import io.deephaven.server.table.stats.BigIntegerChunkedNumericalStats;
import io.deephaven.server.table.stats.ByteChunkedNumericalStats;
import io.deephaven.server.table.stats.ChunkedStatsKernel;
import io.deephaven.server.table.stats.DoubleChunkedNumericalStats;
import io.deephaven.server.table.stats.FloatChunkedNumericalStats;
import io.deephaven.server.table.stats.IntegerChunkedNumericalStats;
import io.deephaven.server.table.stats.LongChunkedNumericalStats;
import io.deephaven.server.table.stats.ShortChunkedNumericalStats;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface ChunkedNumericalStatsKernel
extends ChunkedStatsKernel {
    public static ChunkedNumericalStatsKernel makeChunkedNumericalStats(Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return new ByteChunkedNumericalStats();
        }
        if (type == Short.class || type == Short.TYPE) {
            return new ShortChunkedNumericalStats();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerChunkedNumericalStats();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongChunkedNumericalStats();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatChunkedNumericalStats();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleChunkedNumericalStats();
        }
        if (type == BigInteger.class) {
            return new BigIntegerChunkedNumericalStats();
        }
        if (type == BigDecimal.class) {
            return new BigDecimalChunkedNumericalStats();
        }
        throw new IllegalStateException("Invalid type for ChunkedNumericalStatsKernel: " + type.getCanonicalName());
    }

    default public double avg(long count, double sumValue) {
        if (count == 0L) {
            return -1.7976931348623157E308;
        }
        return sumValue / (double)count;
    }

    default public double stdDev(long count, double sum, double sumOfSquares) {
        if (count <= 1L) {
            return -1.7976931348623157E308;
        }
        return Math.sqrt((sumOfSquares - sum * sum / (double)count) / (double)(count - 1L));
    }
}

