/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import gnu.trove.TCharCollection;
import gnu.trove.map.hash.TCharLongHashMap;
import gnu.trove.set.hash.TCharHashSet;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.table.iterators.ChunkedCharacterColumnIterator;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedStatsKernel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class CharacterChunkedStats
implements ChunkedStatsKernel {
    private final int maxUniqueToCollect;
    private final int maxUniqueToDisplay;

    public CharacterChunkedStats(int maxUniqueToCollect, int maxUniqueToDisplay) {
        this.maxUniqueToCollect = maxUniqueToCollect;
        this.maxUniqueToDisplay = maxUniqueToDisplay;
    }

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        long count = 0L;
        int uniqueCount = 0;
        TCharLongHashMap countValues = new TCharLongHashMap();
        boolean useSet = false;
        TCharHashSet uniqueValues = new TCharHashSet();
        try (ChunkedCharacterColumnIterator iterator = new ChunkedCharacterColumnIterator((ChunkSource)(usePrev ? columnSource.getPrevSource() : columnSource), (RowSequence)rowSet);){
            char val;
            while (iterator.hasNext()) {
                val = iterator.nextChar();
                if (val == '\uffff') continue;
                ++count;
                if (countValues.adjustOrPutValue(val, 1L, 1L) != 1L || ++uniqueCount <= this.maxUniqueToCollect) continue;
                uniqueValues.addAll((TCharCollection)countValues.keySet());
                countValues.clear();
                useSet = true;
                break;
            }
            while (iterator.hasNext()) {
                val = iterator.nextChar();
                if (val == '\uffff') continue;
                ++count;
                uniqueValues.add(val);
            }
        }
        if (useSet) {
            return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.intCol((String)"UNIQUE_VALUES", (int[])new int[]{uniqueValues.size()})});
        }
        ArrayList sorted = new ArrayList(countValues.size());
        countValues.forEachEntry((o, c) -> {
            sorted.add(Map.entry(Objects.toString(Character.valueOf(o)), c));
            return true;
        });
        sorted.sort(Map.Entry.comparingByValue().reversed());
        int resultCount = Math.min(this.maxUniqueToDisplay, sorted.size());
        String[] uniqueKeys = new String[resultCount];
        long[] uniqueCounts = new long[resultCount];
        Iterator iter = sorted.iterator();
        for (int i = 0; i < resultCount; ++i) {
            Map.Entry entry = (Map.Entry)iter.next();
            uniqueKeys[i] = (String)entry.getKey();
            uniqueCounts[i] = (Long)entry.getValue();
        }
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), TableTools.intCol((String)"UNIQUE_VALUES", (int[])new int[]{countValues.size()}), new ColumnHolder("UNIQUE_KEYS", String[].class, String.class, false, (Object[])new String[][]{uniqueKeys}), new ColumnHolder("UNIQUE_COUNTS", long[].class, Long.TYPE, false, (Object[])new long[][]{uniqueCounts})});
    }
}

