/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;

public class ByteChunkedNumericalStats
implements ChunkedNumericalStatsKernel {
    private long count = 0L;
    private long sum = 0L;
    private boolean useFloatingSum = false;
    private double floatingSum = 0.0;
    private long absSum = 0L;
    private boolean useFloatingAbsSum = false;
    private double floatingAbsSum = 0.0;
    private long sumOfSquares = 0L;
    private boolean useFloatingSumOfSquares = false;
    private double floatingSumOfSquares = 0.0;
    private byte min = (byte)-128;
    private byte max = (byte)-128;
    private byte absMin = (byte)-128;
    private byte absMax = (byte)-128;

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        try (ChunkSource.GetContext getContext = columnSource.makeGetContext(2048);){
            RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();
            while (rsIt.hasMore()) {
                RowSequence nextKeys = rsIt.getNextRowSequenceWithLength(2048L);
                ByteChunk chunk = (usePrev ? columnSource.getPrevChunk(getContext, nextKeys) : columnSource.getChunk(getContext, nextKeys)).asByteChunk();
                double chunkedOverflowSum = 0.0;
                double chunkedOverflowAbsSum = 0.0;
                double chunkedOverflowSumOfSquares = 0.0;
                int chunkSize = chunk.size();
                for (int ii = 0; ii < chunkSize; ++ii) {
                    byte val = chunk.get(ii);
                    if (val == -128) continue;
                    byte absVal = (byte)Math.abs(val);
                    if (this.count == 0L) {
                        this.min = this.max = val;
                        this.absMax = this.absMin = absVal;
                    } else {
                        if (val < this.min) {
                            this.min = val;
                        }
                        if (val > this.max) {
                            this.max = val;
                        }
                        if (absVal < this.absMin) {
                            this.absMin = absVal;
                        }
                        if (absVal > this.absMax) {
                            this.absMax = absVal;
                        }
                    }
                    ++this.count;
                    if (!this.useFloatingSum) {
                        try {
                            this.sum = Math.addExact(this.sum, (long)val);
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingSum = true;
                            this.floatingSum = this.sum;
                            chunkedOverflowSum = val;
                        }
                    } else {
                        chunkedOverflowSum += (double)val;
                    }
                    if (!this.useFloatingAbsSum) {
                        try {
                            this.absSum = Math.addExact(this.absSum, (long)absVal);
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingAbsSum = true;
                            this.floatingAbsSum = this.absSum;
                            chunkedOverflowAbsSum = absVal;
                        }
                    } else {
                        chunkedOverflowAbsSum += (double)absVal;
                    }
                    if (!this.useFloatingSumOfSquares) {
                        try {
                            this.sumOfSquares = Math.addExact(this.sumOfSquares, (long)Math.multiplyExact(val, (int)val));
                        }
                        catch (ArithmeticException ae) {
                            this.useFloatingSumOfSquares = true;
                            this.floatingSumOfSquares = this.sumOfSquares;
                            chunkedOverflowSumOfSquares = Math.pow(val, 2.0);
                        }
                        continue;
                    }
                    chunkedOverflowSumOfSquares += Math.pow(val, 2.0);
                }
                if (this.useFloatingSum) {
                    this.floatingSum += chunkedOverflowSum;
                }
                if (this.useFloatingAbsSum) {
                    this.floatingAbsSum += chunkedOverflowAbsSum;
                }
                if (!this.useFloatingSumOfSquares) continue;
                this.floatingSumOfSquares += chunkedOverflowSumOfSquares;
            }
        }
        double avg = this.avg(this.count, this.useFloatingSum ? this.floatingSum : (double)this.sum);
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{this.count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), this.useFloatingSum ? TableTools.doubleCol((String)"SUM", (double[])new double[]{this.floatingSum}) : TableTools.longCol((String)"SUM", (long[])new long[]{this.sum}), this.useFloatingAbsSum ? TableTools.doubleCol((String)"SUM_ABS", (double[])new double[]{this.floatingAbsSum}) : TableTools.longCol((String)"SUM_ABS", (long[])new long[]{this.absSum}), this.useFloatingSumOfSquares ? TableTools.doubleCol((String)"SQRD_SUM", (double[])new double[]{this.floatingSumOfSquares}) : TableTools.longCol((String)"SUM_SQRD", (long[])new long[]{this.sumOfSquares}), TableTools.byteCol((String)"MIN", (byte[])new byte[]{this.min}), TableTools.byteCol((String)"MAX", (byte[])new byte[]{this.max}), TableTools.byteCol((String)"MIN_ABS", (byte[])new byte[]{this.absMin}), TableTools.byteCol((String)"MAX_ABS", (byte[])new byte[]{this.absMax}), TableTools.doubleCol((String)"AVG", (double[])new double[]{avg}), TableTools.doubleCol((String)"AVG_ABS", (double[])new double[]{this.avg(this.count, this.absSum)}), TableTools.doubleCol((String)"STD_DEV", (double[])new double[]{this.stdDev(this.count, this.useFloatingSum ? this.floatingSum : (double)this.sum, this.useFloatingSumOfSquares ? this.floatingSumOfSquares : (double)this.sumOfSquares)})});
    }
}

