/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.stats;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.util.TableTools;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;
import io.deephaven.util.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigIntegerChunkedNumericalStats
implements ChunkedNumericalStatsKernel {
    private static final int SCALE = Configuration.getInstance().getIntegerWithDefault("BigDecimalStdOperator.scale", 10);
    private long count = 0L;
    private BigInteger sum = BigInteger.ZERO;
    private BigInteger absSum = BigInteger.ZERO;
    private BigInteger sqrdSum = BigInteger.ZERO;
    private BigInteger min = null;
    private BigInteger max = null;
    private BigInteger absMin = null;
    private BigInteger absMax = null;

    @Override
    public Table processChunks(RowSet rowSet, ColumnSource<?> columnSource, boolean usePrev) {
        try (ChunkSource.GetContext getContext = columnSource.makeGetContext(2048);){
            RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();
            while (rsIt.hasMore()) {
                RowSequence nextKeys = rsIt.getNextRowSequenceWithLength(2048L);
                ObjectChunk chunk = (usePrev ? columnSource.getPrevChunk(getContext, nextKeys) : columnSource.getChunk(getContext, nextKeys)).asObjectChunk();
                int chunkSize = chunk.size();
                for (int ii = 0; ii < chunkSize; ++ii) {
                    BigInteger val = (BigInteger)chunk.get(ii);
                    if (val == null) continue;
                    BigInteger absVal = val.abs();
                    if (this.count == 0L) {
                        this.min = this.max = val;
                        this.absMax = this.absMin = absVal;
                    } else {
                        if (val.compareTo(this.min) < 0) {
                            this.min = val;
                        }
                        if (val.compareTo(this.max) > 0) {
                            this.max = val;
                        }
                        if (absVal.compareTo(this.absMin) < 0) {
                            this.absMin = absVal;
                        }
                        if (absVal.compareTo(this.absMax) > 0) {
                            this.absMax = absVal;
                        }
                    }
                    ++this.count;
                    this.sum = this.sum.add(val);
                    this.absSum = this.absSum.add(absVal);
                    this.sqrdSum = this.sqrdSum.add(absVal.multiply(absVal));
                }
            }
        }
        BigDecimal c = BigDecimal.valueOf(this.count);
        BigDecimal avg = this.count == 0L ? null : new BigDecimal(this.sum).divide(c, SCALE, RoundingMode.HALF_UP);
        BigDecimal absAvg = this.count == 0L ? null : new BigDecimal(this.absSum).divide(c, SCALE, RoundingMode.HALF_UP);
        BigDecimal stdDev = this.count <= 1L ? null : BigDecimalUtils.sqrt((BigDecimal)new BigDecimal(this.sqrdSum).subtract(avg.pow(2).multiply(c)).divide(BigDecimal.valueOf(this.count - 1L), SCALE, RoundingMode.HALF_UP), (int)SCALE);
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)"COUNT", (long[])new long[]{this.count}), TableTools.longCol((String)"SIZE", (long[])new long[]{rowSet.size()}), new ColumnHolder("SUM", BigInteger.class, null, false, (Object[])new BigInteger[]{this.sum}), new ColumnHolder("SUM_ABS", BigInteger.class, null, false, (Object[])new BigInteger[]{this.absSum}), new ColumnHolder("SUM_SQRD", BigInteger.class, null, false, (Object[])new BigInteger[]{this.sqrdSum}), new ColumnHolder("MIN", BigInteger.class, null, false, (Object[])new BigInteger[]{this.min}), new ColumnHolder("MAX", BigInteger.class, null, false, (Object[])new BigInteger[]{this.max}), new ColumnHolder("MIN_ABS", BigInteger.class, null, false, (Object[])new BigInteger[]{this.absMin}), new ColumnHolder("MAX_ABS", BigInteger.class, null, false, (Object[])new BigInteger[]{this.absMax}), new ColumnHolder("AVG", BigDecimal.class, null, false, (Object[])new BigDecimal[]{avg}), new ColumnHolder("AVG_ABS", BigDecimal.class, null, false, (Object[])new BigDecimal[]{absAvg}), new ColumnHolder("STD_DEV", BigDecimal.class, null, false, (Object[])new BigDecimal[]{stdDev})});
    }
}

