/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.AbstractNormalizeFilters;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NormalizeNots
extends AbstractNormalizeFilters {
    private static final NormalizeNots INSTANCE = new NormalizeNots();

    public static Condition exec(Condition filter) {
        return FilterVisitor.accept(filter, INSTANCE);
    }

    private NormalizeNots() {
    }

    @Override
    public Condition onNot(Condition filter) {
        return FilterVisitor.accept(filter, NormalizeInvertedFilters.INSTANCE);
    }

    static class NormalizeInvertedFilters
    implements FilterVisitor<Condition> {
        private static final NormalizeInvertedFilters INSTANCE = new NormalizeInvertedFilters();

        private NormalizeInvertedFilters() {
        }

        @Override
        public Condition onAnd(List<Condition> filtersList) {
            return NormalizeFilterUtil.doOr(filtersList, this);
        }

        @Override
        public Condition onOr(List<Condition> filtersList) {
            return NormalizeFilterUtil.doAnd(filtersList, this);
        }

        @Override
        public Condition onNot(Condition filter) {
            return FilterVisitor.accept(filter, INSTANCE);
        }

        @Override
        public Condition onComparison(CompareCondition.CompareOperation operation, CaseSensitivity caseSensitivity, Value lhs, Value rhs) {
            switch (operation) {
                case LESS_THAN: {
                    operation = CompareCondition.CompareOperation.GREATER_THAN_OR_EQUAL;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    operation = CompareCondition.CompareOperation.GREATER_THAN;
                    break;
                }
                case GREATER_THAN: {
                    operation = CompareCondition.CompareOperation.LESS_THAN_OR_EQUAL;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    operation = CompareCondition.CompareOperation.LESS_THAN;
                    break;
                }
                case EQUALS: {
                    operation = CompareCondition.CompareOperation.NOT_EQUALS;
                    break;
                }
                case NOT_EQUALS: {
                    operation = CompareCondition.CompareOperation.EQUALS;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operation " + String.valueOf(operation));
                }
            }
            return NormalizeFilterUtil.doComparison(operation, caseSensitivity, lhs, rhs);
        }

        @Override
        public Condition onIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
            return NormalizeFilterUtil.doIn(target, candidatesList, caseSensitivity, NormalizeInvertedFilters.invertMatchType(matchType));
        }

        @NotNull
        private static MatchType invertMatchType(MatchType matchType) {
            switch (matchType) {
                case REGULAR: {
                    matchType = MatchType.INVERTED;
                    break;
                }
                case INVERTED: {
                    matchType = MatchType.REGULAR;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown matchType " + String.valueOf(matchType));
                }
            }
            return matchType;
        }

        @Override
        public Condition onContains(Reference reference, String searchString, CaseSensitivity caseSensitivity, MatchType matchType) {
            return NormalizeFilterUtil.doContains(reference, searchString, caseSensitivity, NormalizeInvertedFilters.invertMatchType(matchType));
        }

        @Override
        public Condition onMatches(Reference reference, String regex, CaseSensitivity caseSensitivity, MatchType matchType) {
            return NormalizeFilterUtil.doMatches(reference, regex, caseSensitivity, NormalizeInvertedFilters.invertMatchType(matchType));
        }

        @Override
        public Condition onIsNull(Reference reference) {
            return NormalizeFilterUtil.doInvert(NormalizeFilterUtil.doIsNull(reference));
        }

        @Override
        public Condition onInvoke(String method, @Nullable Value target, List<Value> argumentsList) {
            if (target == null) {
                return NormalizeFilterUtil.doInvert(NormalizeFilterUtil.doInvoke(method, argumentsList));
            }
            return NormalizeFilterUtil.doInvert(NormalizeFilterUtil.doInvoke(method, target, argumentsList));
        }

        @Override
        public Condition onSearch(String searchString, List<Reference> optionalReferencesList) {
            throw new IllegalStateException("Cannot not() a search");
        }
    }
}

